clear
close all
clc
%%
P1=9.9240e+01 + 1.3571e+03i;
U1= 0.0295;
ariel_ref=TA_System('ariel_ref',1e5,86,'Air','Water',0,[P1,U1,298]);
% Speaker=TA_VE_Speaker('Speaker',ariel_ref,6e-4,6,0,7,5e-3,0,0,0);
% Speaker.V=256.256293317699*cos(198.057587659865)+1i*256.256293317699*sin(198.057587659865);
% Speaker.V=2;
% ariel_ref.Begin(2)=0.001;
% C1=TA_Compliance('C1',ariel_ref,0.001,0.061416);
% C1.Length=0.1;
Cold_Duct=TA_Round_Duct('Cold Duct',ariel_ref,0.735+0.01,0.1);
Cold_Duct.Area=0.001735;
%Cold_Duct.Jacket=1;
CHX=TA_Plate_HX('CHX',ariel_ref,0.02,Cold_Duct.Diameter,0.0009,0.6,'Copper',-12.55);
%CHX.Gas_Area_Ratio=0.6;
Stack=TA_Rectangular_Stack('Stack',ariel_ref,0.095,Cold_Duct.Diameter,...
    4.6e-4,4.6e-4,0.85,'Ceramic');


AHX=TA_Plate_HX('AHX',ariel_ref,0.02,Cold_Duct.Diameter,0.000255,0.67,'Copper',0);
%AHX.Gas_Area_Ratio=0.67;
Jac=TA_Jacket_Target('Jac',ariel_ref);
Ambient_Duct=TA_Round_Duct('Ambient Duct',ariel_ref,0.055,Cold_Duct.Diameter);
Ambient_Duct.Jacket=1;
End=TA_Hard_End('End',ariel_ref);
%% run
ariel_ref.runSystem(1);
%ariel_ref.PlotSystem('Derived')
%%
%% add guesses and targets
ariel_ref.addGuess('Real','Begin',2)                       %begining velocity
ariel_ref.addGuess('Real','Begin',1)                       %begining pressure
ariel_ref.addGuess('Imag','Begin',1)                       %begining pressure
%ariel_ref.addGuess('Begin',3)                              %begining pressure
ariel_ref.addGuess('CHX','Heat_Input')                     %heat at CHX 
ariel_ref.addGuess('AHX','Heat_Input')                     %heat at AHX 

ariel_ref.addTarget('AHX','SolidT')                 %ambient temperature
ariel_ref.addTarget('Abs','End','Pressure')                %measured pressure
ariel_ref.addTarget('Imag','End','Target_Value')           %imaginary part of 1/impedance at hardend
ariel_ref.addTarget('Real','End','Target_Value')           %real part of 1/impedance at hardend
ariel_ref.addTarget('Jac','Target_Value')                  %Jacket target 

%% converge
targetvalues=[295, 4300,0,0,0];
guessvalues=[1.802959e-02, 1.438598e+02, -7.370434e+02, 2.546789e+00, -3.824246e+00];

tic
[X,Fvec]=ariel_ref.Run_System_GT(guessvalues,targetvalues);
toc  
ariel_ref.PlotSystem('Derived');
error
%%
 param1={'CHX','Heat_Input'};
 param2={'AHX','SolidT'};
 param3={'CHX','SolidT'};
 param4={'CHX','Temperature',1};
 result=ChangeSmooth(ariel_ref,{'Begin',3},280,20,'CollectData'...
 ,'CollectParams',param1,param2,param3,param4);
TdifW=result.Parameter_AHX_SolidT-result.Parameter_CHX_Temperature_1;
QcW=result.Parameter_CHX_Heat_Input;
expQW=[3.288,2.794,fliplr([0,0.456,1.017,1.712,2.151])];
expdTW=[0.3,1.5,fliplr([10.1,9.1,7.3,5.32,4])];
%%
%guessvalues=[1.802959e-02, 1.438598e+02, -7.370434e+02, 2.546789e+00, -3.824246e+00];
ariel_ref.Begin(3)=300;
%ariel_ref.Run_System_GT(guessvalues,targetvalues);
%ChangeGas(ariel_ref,'2-Propanol','reactive',10)
guessvalues=[1.776267e-02, 1.602589e+02, -1.847466e+02, 6.735072e+00, -8.142224];
ariel_ref.Reactive='2-Propanol';
[X,Fvec]=ariel_ref.Run_System_GT(guessvalues,targetvalues);
 result=ChangeSmooth(ariel_ref,{'Begin',3},280,20,'CollectData'...
 ,'CollectParams',param1,param2,param3,param4);
TdifP=result.Parameter_AHX_SolidT-result.Parameter_CHX_Temperature_1;
QcP=result.Parameter_CHX_Heat_Input;
expdTP=[0 1.8 4.1 5.85 7.93 10.23 11.5];
expQP=[5.2 3.927 3.1 2.34 1.5 0.725 0];
%%
guessvalues=[1.776267e-02, 1.602589e+02, -1.847466e+02, 6.735072e+00, -8.142224];
ariel_ref.Begin(3)=300;
ariel_ref.Run_System_GT(guessvalues,targetvalues);
SwitchMode(ariel_ref,10)
result=ChangeSmooth(ariel_ref,{'Begin',3},280,20,'CollectData'...
 ,'CollectParams',param1,param2,param3,param4);
Tdifd=result.Parameter_AHX_SolidT-result.Parameter_CHX_Temperature_1;
Qcd=result.Parameter_CHX_Heat_Input;
expQd=[1.785 1.18 0.987 0.697 0.253 0];
expdTd=[0.5 2.77 3.66 6.37 9.2 11.6];
%% plotting
figure
hold on
plot(TdifW,QcW,'-g')
plot(expdTW,expQW,'--g')


plot(TdifP,QcP,'-k')
plot(expdTP,expQP,'--k')

plot(Tdifd,Qcd,'-b')
plot(expdTd,expQd,'--b')

xlim([0,12])
legend('codeW','experimentW','codep','experimentp','codeD','experimentd')
grid on
xlabel('deltaT [k]')
ylabel('Q [W]')