function mutilpleChangeSmooth(MySystem,n,varargin)
%this function changes multiple variables in series
%input should be: mutilpleChangeSmooth(mysystem,n,{param1},value1,{param2},value2)
%where n is the number of steps for change, and mysystem is the system.
%for example:
%mutilpleChangeSmooth(mysystem,10,{'Duct1', 'Length'},10,{'Duct2','length'},5)
% changes the lengths of components "Duct1" and "Duct2" to 10 and 5
% respectively, using 10 steps.
for i=1:2:length(varargin)
    if ~iscell(varargin{i})||~isnumeric(varargin{i+1})
        error('wrong input format')
    end
    ChangeSmooth(MySystem,varargin{i},varargin{i+1},n)
end

