function f = custom_target(operations)
%% custom_target - wrapper for ArithmeticParser
%
% INPUTS: 
%       operations : (string) a string representing arithmetic operations
%       on numbers and properties of a system.
% OUTPUTS: 
%       f : (function_handle) a function that gets a system as input, and
%       outputs an arithmetic manipulation on its' properties. this can and
%       should be used as a custom target for a system.
try
    ast = ArithmeticParser.parse(operations);
catch E
    error("Invalid operation string");
end
f = ArithmeticParser.compileAST(ast);
end