classdef  TA_Impedance_Split<TA_Split
    % a split where Velocity Ratio is determined according to an impedance
    %  and Total power ratio is decided by the user
    properties (SetObservable=true)
        %% unprotected properties
        Impedance
        Total_Power_Ratio      %percentege of total power going into branch
    end

    methods
        function obj = TA_Impedance_Split(name,system,branchnumber,Z,TPratio)
            obj@TA_Split(name,system,branchnumber)
            obj.Impedance=Z;
            obj.Total_Power_Ratio=TPratio;
        end
        function Tpratio=Get_Total_Power_Ratio(obj)
                 Tpratio=obj.Total_Power_Ratio;
        end
        function Ubranch=Get_Branch_Velocity(obj,P_U_T_in)
            Ubranch=P_U_T_in(1)/obj.Impedance;
        end
    end

end

