classdef  TA_Custom_Split<TA_Split
    % a split where Velocity Ratio and Total power ratio are decided by the
    % user

    properties (SetObservable=true)
        %% unprotected properties
        Velocity_Ratio         % fraction of volumetric velocity going into branch
        Total_Power_Ratio      %percentege of total power going into branch
    end

    methods
        function obj = TA_Custom_Split(name,system,branchnumber,vratio,tpratio)
            obj@TA_Split(name,system,branchnumber)
            obj.Velocity_Ratio=vratio;
            obj.Total_Power_Ratio=tpratio;
        end
        function Tpratio=Get_Total_Power_Ratio(obj)
                 Tpratio=obj.Total_Power_Ratio;
        end
        function Ubranch=Get_Branch_Velocity(obj,P_U_T_in)
            vratio=obj.Velocity_Ratio;
            Ubranch=P_U_T_in(2)*vratio;
        end
    end

end

