function success=RemoveSmooth(mySystem,myComponent,n)
%this function removes a component smoothly, while maintaining guesses and
%targets

%% assign input
if ischar(myComponent)
    Loc=mySystem.findLoc(myComponent);
    myComponent=mySystem.Components_H{Loc};
end
%% check if object has a guess or a target associated with it

Guess_Value=mySystem.CollectGuessValues;
Target_Value=mySystem.CollectTargetValues;

[~,isGuess]=mySystem.SearchArray(mySystem.Guesses,myComponent.Name,[]);
[~,isTarget]=mySystem.SearchArray(mySystem.Targets,myComponent.Name,[]);
if isGuess
    error(['remove component "',myComponent.Name,'" from guess list before removing it from system',...
        'use the Function "Remove_Guess"'])
end
if isTarget
    error(['remove component "',myComponent.Name,'" from target list before removing it from system',...
        'use the Function "Remove_Target"'])
end
if isa(myComponent,'TA_Duct')||isa(myComponent,'TA_Stack')||isa(myComponent...
        ,'TA_Cone')||isa(myComponent,'TA_Regenerator')
    %% ducts, stacks etc
    %change the length of the component to 0 and then remove
    L=myComponent.Length;
    try
        results=ChangeSmooth(mySystem,{myComponent.Name,'Length'},1e-13,n,'NoQuestions');
    catch
        results.Converged=0;
        myComponent.Length=L;
        mySystem.Run_System_GT(Guess_Value,Target_Value)
    end
    if results.Converged
        mySystem.Remove(myComponent)
        myComponent.Length=L;
        sprintf(['component "',myComponent.Name,'" removed successfully'])
        success=true;
    else
        sprintf(['failed to remove component"',myComponent.Name,'"  smoothly '])
        success=false;
        myComponent.Length=L;
    end
elseif isa(myComponent,'TA_HX')
    %% heat exchanger
    %change the length and heat input of the component to 0 and then remove
    H=myComponent.Heat_Input;
    L=myComponent.Length;
    
    if H~=0
        try
            results1=ChangeSmooth(mySystem,{myComponent.Name,'Heat_Input'},1e-13,n,'NoQuestions');
            Converged=results1.Converged;
        catch
            results1.Converged=0;
            myComponent.Heat_Input=H;
            mySystem.Run_System_GT(Guess_Value,Target_Value)
        end
    else
        Converged=true;
    end
    if Converged
        try
            results2=ChangeSmooth(mySystem,{myComponent.Name,'Length'},1e-13,n,'NoQuestions');
        catch
            results2.Converged=0;
            myComponent.Length=L;
            mySystem.Run_System_GT(Guess_Value,Target_Value)
        end
        Converged=results2.Converged;
    end
    if Converged
        mySystem.Remove(myComponent)
        myComponent.Heat_Input=H;
        myComponent.Length=L;
        mySystem.runSystem(1);
        sprintf(['component "',myComponent.Name,'" removed successfully'])
        success=true;
    else
        sprintf(['failed to remove component "',myComponent.Name,'" smoothly.'])
        success=false;
        if results1.Converged
            myComponent.Heat_Input=H;
            mySystem.Run_System_GT(Guess_Value,Target_Value)
        end
    end
elseif isa(myComponent,'TA_Compliance')
    %% compliance
    V=myComponent.Volume;
    try
        results=ChangeSmooth(mySystem,{myComponent.Name,'Volume'},1e-13,n,'NoQuestions');
    catch
        results.Converged=0;
        myComponent.Volume=V;
        mySystem.Run_System_GT(Guess_Value,Target_Value)
    end
    if results.Converged
        mySystem.Remove(myComponent)
        myComponent.Volume=V;
        mySystem.runSystem(1);
        sprintf(['component "',myComponent.Name,'" removed successfully'])
        success=true;
    else
        sprintf(['failed to remove component "',myComponent.Name,'" smoothly.'])
        success=false;
    end
elseif isa(myComponent,'TA_VE_Speaker')
    %% compliance
    try
        results=ChangeSmooth(mySystem,{myComponent.Name,'Silencer'},1,n,'NoQuestions');
    catch
        results.Converged=0;
        myComponent.Silencer=0;
        mySystem.Run_System_GT(Guess_Value,Target_Value)
    end
    if results.Converged
        mySystem.Remove(myComponent)
        myComponent.Silencer=0;
        mySystem.runSystem(1);
        sprintf(['component "',myComponent.Name,'" removed successfully'])
        success=true;
    else
        sprintf(['failed to remove component "',myComponent.Name,'" smoothly.'])
        success=false;
    end
elseif isa(myComponent,'TA_Liquid_Piston')
    %% Liquid Piston
    %change the rho of the component to 0 and then remove
    rho=myComponent.Rho;
    try
        results=ChangeSmooth(mySystem,{myComponent.Name,'Rho'},1e-13,n,'NoQuestions');
    catch
        results.Converged=0;
        myComponent.Rho=rho;
        mySystem.Run_System_GT(Guess_Value,Target_Value)
    end
    if results.Converged
        mySystem.Remove(myComponent)
        myComponent.Rho=rho;
        sprintf(['component "',myComponent.Name,'" removed successfully'])
        success=true;
    else
        sprintf(['failed to remove component"',myComponent.Name,'"  smoothly '])
        success=false;
        myComponent.Rho=rho;
    end
elseif isa(myComponent,'TA_rget')
    success=1;
    mySystem.Remove(myComponent)
    %% other component
elseif isa(myComponent,'TA_Component')
    sprintf(['No method for removing a component of class "',class(myComponent),...
        '" smoothly. inserting it regularly'])
else
    error('not a component')
end
end

