                                                           
function [Fvec, Nfev, X, Info,Erinf] = Hybrid_Powel(func,X,varargin) 
%This function performs a shooting  fo minimize the value of "func" by
%changing the value of X. %this function is an adaptation of the fortran 
%function DNSQ, where Shooting is performed using the Powell Hybrid
%Method.

%See:  
%Powell,A Hybrid Method for Nonlinear Equations 1970, Numerical Methods for 
%Nonlinear Algebraic Equations, London, Gordon and Breach Science 
%Publishers (1970), pp. 87-114

% http://www.lahey.com/docs/lgf13help/slatec/DNSQE.htm

%input parameters- 
% func- the function to be miniized
% X- initial guess
% varargin can include a vector of values for solver pamters:
% DNSQ(func,X,Xtol,Factor,Maxfev,Epsfunc)
%where:
%Xtol-          solver termination criteria (default-1e-7)
%Factor-        initial step bound  (default-100)
%Maxfev-        maximum function evaluations (default- 250)
%Epsfunc        function accuracy estimation (default 1e-12)

%output parameters-
% Fvec -vector of function values at final point
% Nfev - number of function evaluations
% X    - converged result
% Info - information about return reason. 
% Erinf- information about the first error to occur in function f, if such
%        an error exists
%where:
% 0- invalid input
% 1- successfull convergance
% 2- TOO MANY FUNCTION EVALUATIONS
% 3- XTOL TOO SMALL
% 4- ITERATION NOT MAKING GOOD PROGRESS
%% changable charactaristics
if isempty(varargin)
%  Termination occurs when the relative error between two consecutive iterates is at most XTOL
Xtol = 1e-7;
%initial step bound
Factor = 100;    
%maximal function evaluations
Maxfev = 250;  
% This approximation assumes that the relative errors in the functions are of the order of EPSFCN
Epsfunc =  1e-12;
else
    Xtol=varargin{1};
    Factor=varargin{2};
    Maxfev=varargin{3};
    Epsfunc=varargin{4};
end
%% non-changable charactaristics
N=length(X);
Iopt = 2;   % select Iopt=1 only if you have a method for calculating jacobian
%if mode=1, % select mod=2 only of you want to customly scale the variables
Mode = 1;                           
Ml = N;                             %relevant only if the jacobian is banded.
Mu = N;                             %relevant only if the jacobian is banded.
Erinf=[];
%% initialize vectorss

Ldfjac = N;
Lr = (N*(N+1))/2; 
R = zeros(1, Lr);
Fjac = zeros(N);
Diag = ones(1,N);
Fvec = zeros(1,N);
Wa1 = zeros(1,N);
Wa2 = zeros(1,N);
Wa3 = zeros(1,N);
Nprint = 0;
%%
               
    %                                                                       
    %     BEGIN BLOCK PERMITTING ...EXITS TO 320                            
    %***FIRST EXECUTABLE STATEMENT  DNSQ1                                    
    %    
    epsmch = 2.22e-16;
    Info = 0; 
    iflag = 0; 
    Nfev = 0;
    %                                                                       
    %        CHECK THE INPUT PARAMETERS FOR ERRORS.                         
    %                                                                       
    %     ...EXIT                                                           
    gt=0;
    while true
        if (~(Iopt>=1 && Iopt<=2 && N>0 && Xtol>=0 &&       ...
                 Maxfev>0 && Ml>=0 && Mu>=0 && Factor>0 &&     ...
                 Ldfjac>=N && Lr>=(N*(N+1))/2 ))
             break;
        end
        if ( Mode==2 )  
            for j = 1 : N 
             %     .........EXIT                                                     
                 if ( Diag(j)<= 0 ) 
                    gt=1;
                    break;
                 end
            end
            if (gt==1) 
                break;
            end
        end
        %                                                                       
        %%        EVALUATE THE FUNCTION AT THE STARTING POINT                    
        %        AND CALCULATE ITS NORM.                                        
        %                                                                       
        iflag = 1;
        try
        Fvec =  func(X); %% call to input function
        catch ME
            warning('system encounters error with initial guess!')
            rethrow(ME)
        end
        Nfev = 1; 
        %     ...EXIT                                                           
        if ( iflag < 0 )
            break;
        end
        fnorm = DENORM(N,Fvec);  %%%% slightly different than fortran
        %                                                                       
        %%        INITIALIZE ITERATION COUNTER AND MONITORS.                     
        %                                                                       
        iter = 1; 
        ncsuc = 0; 
        ncfail = 0; 
        nslow1 = 0;
        nslow2 = 0; 
        %                                                                       
        %%        BEGINNING OF THE OUTER LOOP.                                   
        %                                                                       
        %           BEGIN BLOCK PERMITTING ...EXITS TO 90                       
        while ( true ) 
            jeval = true; 
            %                                                                       
            %%              CALCULATE THE JACOBIAN MATRIX.                           
            %                                                                       
            if ( Iopt==2 )  
            %                                                                       
            %                 CODE APPROXIMATES THE JACOBIAN                        
            %                                                                       
                iflag = 2; 
                [X, Fjac, Wa1, Wa2] = DFDJC1(func,N,X,Fvec,Fjac,iflag, ...
                                             Ml,Mu,Epsfunc,Erinf);                                              
                Nfev = Nfev + min(Ml+Mu+1,N); 
            end
            %                                                                       
            %     .........EXIT                                                     
            if ( iflag<0 ) 
                break;
            end
            %                                                                       
            %%              COMPUTE THE QR FACTORIZATION OF THE JACOBIAN.            
            %
            [Wa1, Wa2, Wa3, Fjac] = DQRFAC(N,N,Fjac,false,Wa1,Wa2,Wa3); 
            %                                                                       
            %%       ON THE FIRST ITERATION AND IF MODE IS 1, SCALE ACCORDING 
            %          TO THE NORMS OF THE COLUMNS OF THE INITIAL JACOBIAN.     
            %                                                                       
            %           ...EXIT                                                     
            if ( iter==1 )    
                if ( Mode~=2 )
                    Diag = Wa2;
                    Diag(Diag == 0) = 1;
                end
                %                                                                       
                %     ON THE FIRST ITERATION, CALCULATE THE NORM OF THE SCALED 
                %           X AND INITIALIZE THE STEP BOUND DELTA.                   
                %
                Wa3 = Diag .* X;
                xnorm = DENORM(N,Wa3); 
                delta = Factor*xnorm; 
                if ( delta==0 ) 
                    delta = Factor;
                end
            end
            %                                                                       
            %%           FORM (Q TRANSPOSE)*FVEC AND STORE IN QTF.                   
            %
            Qtf = Fvec; 
            for j = 1 : N 
                if ( Fjac(j,j)~= 0 )  
                    sum = 0; 
                    for i = j : N 
                        sum = sum + Fjac(i,j)*Qtf(i); 
                    end
                    temp = -sum/Fjac(j,j); 
                    for i = j : N 
                        Qtf(i) = Qtf(i) + Fjac(i,j)*temp; 
                    end
                end
            end
            %                                                                       
            %%           COPY THE TRIANGULAR FACTOR OF THE QR FACTORIZATION INTO R.  
            %                                                                       
            %sing = false; 
            for j = 1 : N 
                l = j; 
                jm1 = j - 1; 
                if ( jm1>=1 )  
                    for i = 1 : jm1 
                        R(l) = Fjac(i,j); 
                        l = l + N - i; 
                    end
                end
                R(l) = Wa1(j); 
                if ( Wa1(j)==0 ) 
                end
            end
            %                                                                       
            %%           ACCUMULATE THE ORTHOGONAL FACTOR IN FJAC.                   
            %
            [Fjac, Wa1] = DQFORM(N,N,Fjac,Wa1);
            %                                                                       
            %%           RESCALE IF NECESSARY.                                       
            %                                                                       
            if ( Mode~=2 )
                Diag = max(Diag, Wa2);
            end
            %                                                                       
            %%           BEGINNING OF THE INNER LOOP.                                
            %                                                                       
            %                                                                       
            %              IF REQUESTED, CALL func TO ENABLE PRINTING OF ITERATES.   
            %      
            while( true )
                if ( Nprint>0 )  
                    iflag = 0; 
                    if( mod(iter-1,Nprint)==0 )
                        Fvec = func(x); %% call to input function
                    end
                    %     ............EXIT                                                  
                    if ( iflag<0 ) 
                            gt=1;
                            break;
                    end
                end         
                %                                                                       
                %%              DETERMINE THE DIRECTION P.                               
                %         
                Wa1 = DDOGLG(N,R,Diag,Qtf,delta,Wa1); 
                %                                                                       
                %    STORE THE DIRECTION P AND X + P. CALCULATE THE NORM OF P.
                % 
                Wa1 = -Wa1;
                Wa2 = X + Wa1;
                Wa3 = Diag.* Wa1;
                pnorm = DENORM(N,Wa3); 
                %                                                                       
                %%          ON THE FIRST ITERATION, ADJUST THE INITIAL STEP BOUND.   
                %                                                                       
                if ( iter==1 ) 
                    delta = min(delta,pnorm);
                end
                %                                                                       
                %%       EVALUATE THE FUNCTION AT X + P AND CALCULATE ITS NORM.   
                %                                                                       
                iflag = 1;
                try
                    Wa4 = func(Wa2);    % should be func(Wa2)
                catch ME
                    %if in error occurs, return info and output is huge
                    Wa4=ones(1,N)*1e6;
                    if isempty(Erinf)
                        Erinf.X=Wa2;
                        Erinf.I=ME.identifier;
                    end
                end
                Nfev = Nfev + 1;
                %     .........EXIT
                if ( iflag<0 )
                    gt=1;
                    break;
                end 
                fnorm1 = DENORM(N,Wa4); 
                %                                                                       
                %%              COMPUTE THE SCALED ACTUAL REDUCTION.                     
                %                                                                       
                actred = -1; 
                if ( fnorm1<fnorm ) 
                    actred = 1 - (fnorm1/fnorm)^2;
                end
                %                                                                       
                %              COMPUTE THE SCALED PREDICTED REDUCTION.                  
                %                                                                       
                l = 1; 
                for i = 1 : N 
                    sum = 0; 
                    for j = i : N 
                        sum = sum + R(l)*Wa1(j); 
                        l = l + 1; 
                    end
                    Wa3(i) = Qtf(i) + sum; 
                end
                temp = DENORM(N,Wa3); 
                prered = 0; 
                if( temp<fnorm ) 
                    prered = 1 - (temp/fnorm)^2;
                end
                %                                                                       
                %%              COMPUTE THE RATIO OF THE ACTUAL TO THE PREDICTED         
                %              REDUCTION.                                               
                %                                                                       
                ratio = 0; 
                if ( prered>0 ) 
                    ratio = actred/prered;
                end
                %                                                                       
                %%              UPDATE THE STEP BOUND.                                   
                %                                                                       
                if ( ratio>=0.1 )  
                    ncfail = 0; 
                    ncsuc = ncsuc + 1;
                    if ( ratio>=0.5 || ncsuc>1 ) 
                        delta = max(delta,pnorm/0.5);
                    end
                    if ( abs(ratio-1)<=0.1 ) 
                        delta = pnorm/0.5;
                    end
                else 
                    ncsuc = 0; 
                    ncfail = ncfail + 1; 
                    delta = 0.5*delta; 
                end
                %                                                                       
                %%              TEST FOR SUCCESSFUL ITERATION.                           
                %                                                                       
                if ( ratio>=1e-4 )  
                %                                                                       
                %      SUCCESSFUL ITERATION. UPDATE X, FVEC, AND THEIR NORMS.
                %    
                    X = Wa2;
                    Wa2 = Diag .* X;
                    Fvec = Wa4;
                    xnorm = DENORM(N,Wa2); 
                    fnorm = fnorm1; 
                    iter = iter + 1; 
                end
                %                                                                       
                %              DETERMINE THE PROGRESS OF THE ITERATION.                 
                %                                                                       
                nslow1 = nslow1 + 1; 
                if( actred>=1e-3 ) 
                    nslow1 = 0;
                end
                if ( jeval ) 
                    nslow2 = nslow2 + 1;
                end
                if ( actred>=1 ) %%%%HERE!!!! REPLACED 0.1 with 1
                    nslow2 = 0;
                end
                %                                                                       
                %%              TEST FOR CONVERGENCE.                                    
                %                                                                       
                if ( delta<=Xtol*xnorm || fnorm==0 ) 
                    Info = 1;
                end
                %     .........EXIT                                                     
                if ( Info~=0 ) 
                    gt=1;
                    break;
                end
                %                                                                       
                %%              TESTS FOR TERMINATION AND STRINGENT TOLERANCES.          
                %                                                                       
                if ( Nfev>=Maxfev ) 
                    Info = 2;
                end
                if ( 0.1*max(0.1*delta,pnorm)<=epsmch*xnorm ) 
                    Info = 3; 
                end
                if ( nslow2==5 ) 
                    Info = 4;
                end
                if ( nslow1==10 ) 
                    Info = 5;
                end
                %     .........EXIT                                                     
                if ( Info~=0 ) 
                    gt=1;
                    break;
                end
                %                                                                       
                %%              CRITERION FOR RECALCULATING JACOBIAN                     
                %                                                                       
                %           ...EXIT                                                     
                if ( ncfail==2 ) 
                    break;
                end
                %                                                                       
                %         CALCULATE THE RANK ONE MODIFICATION TO THE JACOBIAN      
                %              AND UPDATE QTF IF NECESSARY.                             
                %                                                                       
                for j = 1 : N 
                    sum = 0; 
                    for i = 1 : N 
                        sum = sum + Fjac(i,j)*Wa4(i); 
                    end
                    Wa2(j) = (sum-Wa3(j))/pnorm; 
                    Wa1(j) = Diag(j)*((Diag(j)*Wa1(j))/pnorm); 
                    if( ratio>=1e-4 ) 
                        Qtf(j) = sum; 
                    end
                end
                %                                                                       
                %%     COMPUTE THE QR FACTORIZATION OF THE UPDATED JACOBIAN.    
                %
                [R, Wa1, Wa2, Wa3, ~] = D1UPDT(N,N,R,Wa1,Wa2,Wa3); 
                Fjac = D1MPYQ(N,N,Fjac,Wa2,Wa3); 
                Qtf =  D1MPYQ(1,N,Qtf,Wa2,Wa3); 
                %                                                                       
                %              END OF THE INNER LOOP.                                   
                %                                                                       
                jeval = false; 
                %                                                                       
                %           END OF THE OUTER LOOP.                                      
                %                                                                       
            end
            if (gt==1) 
                break;
            end
        end
        break;
    end
    if (iflag < 0) 
        Info = iflag; 
    end
    %iflag = 0;
    if (Nprint > 0)
        Fvec = func(x);
    end
    
    
    %% print function summary
    if ( Info < 0 ) 
        error('DNSQ: EXECUTION TERMINATED BECAUSE USER SET IFLAG NEGATIVE.');        
    end
    if ( Info==0 ) 
        error('DNSQ: INVALID INPUT PARAMETER.');        
    end
    if ( Info==2 ) 
        warning('DNSQ: TOO MANY FUNCTION EVALUATIONS.');        
    end
    if ( Info==3 ) 
        warning('DNSQ: XTOL TOO SMALL. NO FURTHER IMPROVEMENT POSSIBLE');        
    end
    if ( Info>=4 ) 
        warning('DNSQ: ITERATION NOT MAKING GOOD PROGRESS');        
    end
end
 %% begining of assisting functions
 %% D1MPYQ
 function A = D1MPYQ(M,N,A,V,W) 
%     APPLY THE FIRST SET OF GIVENS ROTATIONS TO A. 
%
    nm1 = N - 1; 
    if( nm1>=1 )  
        for nmj = 1 : nm1 
            jj = N - nmj; 
            if ( abs(V(jj))>1 ) 
                cos1 = 1/V(jj); 
            end
            if ( abs(V(jj))>1 ) 
                sin1 = sqrt(1-cos1^2);
            end
            if ( abs(V(jj))<=1 ) 
                sin1 = V(jj);
            end
            if ( abs(V(jj))<=1 ) 
                cos1 = sqrt(1-sin1^2);
            end
            for ii = 1 : M 
                temp1 = cos1*A(ii,jj) - sin1*A(ii,N); 
                A(ii,N) = sin1*A(ii,jj) + cos1*A(ii,N); 
                A(ii,jj) = temp1; 
            end
        end 
        
%     APPLY THE SECOND SET OF GIVENS ROTATIONS TO A.                    
%                                                                       
       for jj = 1 : nm1 
           if ( abs(W(jj))>1 ) 
               cos1 = 1/W(jj);
           end
           if ( abs(W(jj))>1 ) 
               sin1 = sqrt(1-cos1^2);
           end
           if ( abs(W(jj))<=1 ) 
               sin1 = W(jj);
           end
           if ( abs(W(jj))<=1 ) 
               cos1 = sqrt(1-sin1^2);
           end
           for ii = 1 : M
               temp1 = cos1*A(ii,jj) + sin1*A(ii,N); 
               A(ii,N) = -sin1*A(ii,jj) + cos1*A(ii,N); 
               A(ii,jj) = temp1; 
           end 
       end 
    end 
 end
%% D1UPDT
function [S, U, V, W, Sing] = D1UPDT(M,N,S,U,V,W)
    giant = 1.79e308; %% as been in original fortran code
    %                                                                       
    %     INITIALIZE THE DIAGONAL ELEMENT POINTER.                          
    %                                                                       
    jjj = (N*(2*M-N+1))/2 - (M-N); 
    %                                                                       
    %     MOVE THE NONTRIVIAL PART OF THE LAST COLUMN OF S INTO W.          
    %                                                                       
    ll = jjj; 
    for ii = N : M 
        W(ii) = S(ll); 
        ll = ll + 1; 
    end 
    %                                                                       
    %     ROTATE THE VECTOR V INTO A MULTIPLE OF THE N-TH UNIT VECTOR       
    %     IN SUCH A WAY THAT A SPIKE IS INTRODUCED INTO W.                  
    %                                                                       
    nm1 = N - 1; 
    if ( nm1>=1 )  
        for nmj = 1 : nm1 
            jj = N - nmj; 
            jjj = jjj - (M-jj+1); 
            W(jj) = 0; 
            if ( V(jj)~=0 )  
%                                                                       
%        DETERMINE A GIVENS ROTATION WHICH ELIMINATES THE               
%        J-TH ELEMENT OF V.                                             
%                                                                       
                if ( abs(V(N))>=abs(V(jj)) )  
                    tan1 = V(jj)/V(N); 
                    cos1 = 0.5/sqrt(0.25+0.25*tan1^2); 
                    sin1 = cos1*tan1; 
                    tau = sin1; 
                else 
                    cotan = V(N)/V(jj); 
                    sin1 = 0.5/sqrt(0.25+0.25*cotan^2); 
                    cos1 = sin1*cotan; 
                    tau = 1; 
                    if ( abs(cos1)*giant>1 ) 
                        tau = 1/cos1;
                    end
                end 
%                                                                       
%        APPLY THE TRANSFORMATION TO V AND STORE THE INFORMATION        
%        NECESSARY TO RECOVER THE GIVENS ROTATION.                      
%                                                                       
                V(N) = sin1*V(jj) + cos1*V(N); 
                V(jj) = tau; 
%                                                                       
%        APPLY THE TRANSFORMATION TO S AND EXTEND THE SPIKE IN W.       
%                                                                       
                ll = jjj; 
                for ii = jj : M 
                    temp2 = cos1*S(ll) - sin1*W(ii); 
                    W(ii) = sin1*S(ll) + cos1*W(ii); 
                    S(ll) = temp2; 
                    ll = ll + 1; 
                end 
            end 
        end 
    end 
%                                                                       
%     ADD THE SPIKE FROM THE RANK 1 UPDATE TO W.                        
%                                                                       
      for ii = 1 : M 
          W(ii) = W(ii) + V(N)*U(ii); 
      end 
%                                                                       
%     ELIMINATE THE SPIKE.                                              
%                                                                       
      Sing = false; 
      if ( nm1>=1 )  
          for jj = 1 : nm1 
              if ( W(jj)~=0 )         
%                                                                       
%           DETERMINE A GIVENS ROTATION WHICH ELIMINATES THE               
%           J-TH ELEMENT OF THE SPIKE.                                     
                  if ( abs(S(jjj))>=abs(W(jj)) )                                                                         
                      tan1 = W(jj)/S(jjj); 
                      cos1 = 0.5/sqrt(0.25+0.25*tan1^2); 
                      sin1 = cos1*tan1; 
                      tau = sin1; 
                  else 
                      cotan = S(jjj)/W(jj); 
                      sin1 = 0.5/sqrt(0.25+0.25*cotan^2); 
                      cos1 = sin1*cotan; 
                      tau = 1; 
                      if ( abs(cos1)*giant>1 ) 
                          tau = 1/cos1;
                      end
                  end
 
%                                                                       
%        APPLY THE TRANSFORMATION TO S AND REDUCE THE SPIKE IN W.       
%                                                                       
                  ll = jjj;         
                  for ii = jj : M 
                      temp2 = cos1*S(ll) + sin1*W(ii); 
                      W(ii) = -sin1*S(ll) + cos1*W(ii); 
                      S(ll) = temp2; 
                      ll = ll + 1; 
                  end 
 
%                                                                       
%        STORE THE INFORMATION NECESSARY TO RECOVER THE                 
%        GIVENS ROTATION.                                               
%                                                                       
                  W(jj) = tau;                   
              end  
%                                                                       
%        TEST FOR ZERO DIAGONAL ELEMENTS IN THE OUTPUT S.               
%                                                                       
              if ( S(jjj)==0 ) 
                  Sing = true;
              end
              jjj = jjj + (M-jj+1); 
          end 
      end 
%                                                                       
%     MOVE W BACK INTO THE LAST COLUMN OF THE OUTPUT S.                 
%                                                                       
      ll = jjj; 
      for ii = N : M 
          S(ll) = W(ii); 
          ll = ll + 1; 
      end 
      if ( S(jjj)==0 ) 
          Sing = true;
      end
end
%% DDOGLG
function X= DDOGLG(N,R,Diag,Qtb,Delta,X) 
    
    epsmch = 2.22e-16; 
%                                                                       
%     FIRST, CALCULATE THE GAUSS-NEWTON DIRECTION.                      
%                                                                       
    jj = (N*(N+1))/2 + 1; 
    for k = 1 : N 
        j = N - k + 1; 
        jp1 = j + 1; 
        jj = jj - k; 
        l = jj + 1; 
        sum = 0; 
        if ( N>=jp1 )  
            for i = jp1 : N
                sum = sum + R(l)*X(i); 
                l = l + 1; 
            end 
        end 
        temp = R(jj); 
        if ( temp==0 )  
            l = j; 
            for i = 1 : j 
                temp = max(temp,abs(R(l))); 
                l = l + N - i; 
            end 
            temp = epsmch*temp; 
            if ( temp==0 ) 
                temp = epsmch;
            end
        end 
        X(j) = (Qtb(j)-sum)/temp; 
    end 
%                                                                       
%     TEST WHETHER THE GAUSS-NEWTON DIRECTION IS ACCEPTABLE.            
%
    Wa1 = zeros(1 , N);
    Wa2 = Diag .* X;
    %{
    for j = 1 , N; 
       Wa1(j) = 0 
       Wa2(j) = Diag(j)*X(j) 
    end
    %}
    qnorm = DENORM(N,Wa2); 
    if ( qnorm>Delta )  
%                                                                       
%     THE GAUSS-NEWTON DIRECTION IS NOT ACCEPTABLE.                     
%     NEXT, CALCULATE THE SCALED GRADIENT DIRECTION.                    
%                                                                       
        l = 1; 
        for j = 1 : N 
            temp = Qtb(j); 
            for i = j : N 
                Wa1(i) = Wa1(i) + R(l)*temp; 
                l = l + 1; 
            end 
            Wa1(j) = Wa1(j)/Diag(j); 
        end 
%                                                                       
%     CALCULATE THE NORM OF THE SCALED GRADIENT AND TEST FOR            
%     THE SPECIAL CASE IN WHICH THE SCALED GRADIENT IS ZERO.            
%                                                                       
       gnorm = DENORM(N,Wa1); 
       sgnorm = 0; 
       alpha = Delta/qnorm; 
       if ( gnorm~=0 )    
%                                                                       
%     CALCULATE THE POINT ALONG THE SCALED GRADIENT                     
%     AT WHICH THE QUADRATIC IS MINIMIZED.                              
%                                                                       
           for j = 1 : N            
                Wa1(j) = (Wa1(j)/gnorm)/Diag(j); 
           end 
           l = 1; 
           for j = 1 : N 
                sum = 0; 
                for i = j : N 
                    sum = sum + R(l)*Wa1(i); 
                    l = l + 1; 
                end 
                Wa2(j) = sum; 
           end 
           temp = DENORM(N,Wa2); 
           sgnorm = (gnorm/temp)/temp; 
%                                                                       
%     TEST WHETHER THE SCALED GRADIENT DIRECTION IS ACCEPTABLE.         
%                                                                       
           alpha = 0;            
           if ( sgnorm<Delta )   
%                                                                       
%     THE SCALED GRADIENT DIRECTION IS NOT ACCEPTABLE.                  
%     FINALLY, CALCULATE THE POINT ALONG THE DOGLEG                     
%     AT WHICH THE QUADRATIC IS MINIMIZED.                              
%                                                                       
               bnorm = DENORM(N,Qtb);         
               temp = (bnorm/gnorm)*(bnorm/qnorm)*(sgnorm/Delta); 
               temp = temp - (Delta/qnorm)*(sgnorm/Delta) ...                     
                ^2 + sqrt((temp-(Delta/qnorm)) ...                        
                ^2+(1-(Delta/qnorm)^2)*(1-(sgnorm/Delta)^2));     
               alpha = ((Delta/qnorm)*(1-(sgnorm/Delta)^2))/temp; 
            end 
       end 
%                                                                       
%     FORM APPROPRIATE CONVEX COMBINATION OF THE GAUSS-NEWTON           
%     DIRECTION AND THE SCALED GRADIENT DIRECTION.                      
%                                                                       
       temp = (1-alpha)*min(sgnorm,Delta); 
       X = temp * Wa1 + alpha * X;
       %{
       for j = 1 , N; 
        X(j) = temp*Wa1(j) + alpha*X(j) 
       end 
       %}
    end 
end
%% DENORM
function DENORM = DENORM(N,X)
      s1 = 0; 
      s2 = 0; 
      s3 = 0; 
      x1max = 0; 
      x3max = 0; 
      floatn = N; 
      rdwarf = 3.834e-20;
      rgiant = 1.304e19;
      agiant = rgiant/floatn; 
      for i = 1 : length(X) %%%%%TEMP CHANGE NIR, was for i=1:N
          xabs = abs(X(i)); 
          if ( xabs>rdwarf && xabs<agiant )   
%                                                                       
%           SUM FOR INTERMEDIATE COMPONENTS.                            
%                                                                       
              s2 = s2 + xabs^2;           
          elseif ( xabs<=rdwarf )  
%                                                                       
%              SUM FOR SMALL COMPONENTS.                                
%                                                                       
              if ( xabs<=x3max )        
                  if ( xabs~=0 ) 
                      s3 = s3 + (xabs/x3max)^2;
                  end
              else
                  s3 = 1 + s3*(x3max/xabs)^2;
                  x3max = xabs; 
              end 
%                                                                       
%              SUM FOR LARGE COMPONENTS.                                
%                                                                       
          elseif ( xabs<=x1max )  
              s1 = s1 + (xabs/x1max)^2; 
          else
              s1 = 1 + s1*(x1max/xabs)^2;
              x1max = xabs; 
          end 
      end 
%                                                                       
%     CALCULATION OF NORM.                                              
%                                                                       
      if ( s1~=0 )  
          DENORM = x1max*sqrt(s1+(s2/x1max)/x1max); 
      elseif ( s2==0 )  
          DENORM = x3max*sqrt(s3); 
      else
          if ( s2>=x3max ) 
              DENORM = sqrt(s2*(1+(x3max/s2)*(x3max*s3)));
          end
          if ( s2<x3max ) 
              DENORM = sqrt(x3max*((s2/x3max)+(x3max*s3)));
          end
      end
end          
%% DFDJC1
function [X, Fjac, Wa1, Wa2] = DFDJC1(func,N,X,Fvec,Fjac, ...
    iflag,Ml,Mu,Epsfunc,Erinf)
%*--DFDJC16
%
%***FIRST EXECUTABLE STATEMENT  DFDJC1
%
epsmch = 1e-16;
epsil = sqrt(max(Epsfunc,epsmch));
msum = Ml + Mu + 1 ;
Wa2 = zeros(size(X));
if ( msum<N )
    %
    %        COMPUTATION OF BANDED APPROXIMATE JACOBIAN.
    %
    for k = 1 : msum
        for j = k: msum: N
            Wa2(j) = X(j);
            h = epsil*abs(Wa2(j)) ;
            if ( h==0 )
                h = epsil;
            end
            X(j) = Wa2(j) + h;
        end
        try
            Wa1 =  func(X); %% call to input function
        catch ME
            %if in error occurs, return info and output is huge
            Wa1=ones(1,N)*1e6;
            if isempty(Erinf)
            Erinf.X=X;
            Erinf.I=ME.identifier;
            end
        end
        if ( iflag<0 )
            break;
        end
        for j = k : msum : N
            X(j) = Wa2(j);
            h = epsil*abs(Wa2(j));
            if ( h==0 )
                h = epsil;
            end
            for i = 1 : N
                Fjac(i,j) = 0;
                if ( i>=j-Mu) && (i<=j+Ml)
                    Fjac(i,j) =(Wa1(i)-Fvec(i))/h;
                end
            end
        end
    end
else
    %
    %        COMPUTATION OF DENSE APPROXIMATE JACOBIAN.
    %
    for j = 1 : N
        temp = X(j);
        h = epsil*abs(temp);
        if ( h==0 )
            h = epsil;
        end
        X(j) = temp + h;
        try
            Wa1 =  func(X); %% call to input function
        catch ME
            %if in error occurs, return info and output is huge
            Wa1=ones(1,N)*1e6;
            if isempty(Erinf)
            Erinf.X=X;
            Erinf.I=ME.identifier;
            end
        end
        if ( iflag<0 )
            break;
        end
        X(j) = temp;
        for i = 1 : N
            Fjac(i,j) = (Wa1(i)-Fvec(i))/h;
        end
    end
end
end
function [Q, Wa] = DQFORM(M,N,Q,Wa)
    minmn = min(M,N); 
    if ( minmn>=2 )  
       for j = 2 : minmn 
           jm1 = j - 1; 
           for i = 1 : jm1 
                Q(i,j) = 0; 
           end 
       end
    end
%                                                                       
%     INITIALIZE REMAINING COLUMNS TO THOSE OF THE IDENTITY MATRIX.     
%                                                                       
    np1 = N + 1; 
    if ( M>=np1 )  
       for j = np1 : M 
           for i = 1 : M 
               Q(i,j) = 0; 
           end 
           Q(j,j) = 1; 
       end
    end
%                                                                       
%     ACCUMULATE Q FROM ITS FACTORED FORM.                              
%                                                                       
    for l = 1 : minmn 
        k = minmn - l + 1; 
        for i = k : M 
            Wa(i) = Q(i,k); 
            Q(i,k) = 0; 
        end 
        Q(k,k) = 1; 
        if ( Wa(k)~=0 )  
            for j = k : M 
                sum = 0; 
                for i = k : M 
                    sum = sum + Q(i,j)*Wa(i); 
                end 
                temp = sum/Wa(k); 
                for i = k : M 
                    Q(i,j) = Q(i,j) - temp*Wa(i); 
                end 
            end 
        end 
    end 
end
%% DQRFAC
function [Sigma, Acnorm, Wa, A] = DQRFAC(M,N,A,Pivot,Sigma,Acnorm,Wa)
    epsmch = 2.22e-16; 
%                                                                       
%     COMPUTE THE INITIAL COLUMN NORMS AND INITIALIZE SEVERAL ARRAYS.   
%                                                                       
    for j = 1 : N 
        Acnorm(j) = DENORM(M,A(:,j)); 
        Sigma(j) = Acnorm(j); 
        Wa(j) = Sigma(j); 
        if ( Pivot ) Ipvt(j) = j; end 
    end 
%                                                                       
%     REDUCE A TO R WITH HOUSEHOLDER TRANSFORMATIONS.                   
%                                                                       
    minmn = min(M,N); 
    for j = 1 : minmn 
       if ( Pivot )   
%                                                                       
%        BRING THE COLUMN OF LARGEST NORM INTO THE PIVOT POSITION.      
%                                                                       
           kmax = j;
           for k = j : N 
               if ( Sigma(k)>Sigma(kmax) ) 
                   kmax = k;
               end
           end 
           if ( kmax~=j )  
               for i = 1 : M 
                   temp = A(j,i); 
                   A(j,i) = A(kmax,i); 
                   A(kmax,i) = temp; 
               end 
               Sigma(kmax) = Sigma(j); 
               Wa(kmax) = Wa(j); 
               k = Ipvt(j); 
               Ipvt(j) = Ipvt(kmax); 
               Ipvt(kmax) = k; 
           end 
       end 
%                                                                       
%        COMPUTE THE HOUSEHOLDER TRANSFORMATION TO REDUCE THE           
%        J-TH COLUMN OF A TO A MULTIPLE OF THE J-TH UNIT VECTOR.        
%                                                                       
       ajnorm = DENORM(M-j+1,A(j:end,j)); 
       %ajnorm = DENORM(M-j+1,A(j,j)); 
       if ( ajnorm~=0 )  
           if ( A(j,j)<0 ) 
               ajnorm = -ajnorm; 
           end
           A(j:M, j) = A(j:M, j) / ajnorm;
           %{
           for i = j : M 
                A(i,j) = A(i,j)/ajnorm; 
           end 
           %}
           A(j,j) = A(j,j) + 1; 
%                                                                       
%        APPLY THE TRANSFORMATION TO THE REMAINING COLUMNS              
%        AND UPDATE THE NORMS.                                          
%                                                                       
           jp1 = j + 1; 
           if ( N>=jp1 )  
               for k = jp1 : N 
                   sum = 0;
                   for i = j : M 
                       sum = sum + A(i,j)*A(i,k);
                   end
                   temp = sum/A(j,j);
                   A(j:M,k) = A(j:M,k) - temp * A(j:end, j);
                   %{ 
                    old version
                   for i = j : M 
                       A(i,k) = A(i,k) - temp*A(i,j);
                   end
                   %}
                   if ( ~(~Pivot || Sigma(k)==0) )
                       temp = A(j,k)/Sigma(k); 
                       Sigma(k) = Sigma(k)*sqrt(max(0,1-temp^2)); 
                       if ( 0.05*(Sigma(k)/Wa(k))^2<=epsmch )  
                           Sigma(k) = DENORM(M-j,A(jp1,k)); 
                           Wa(k) = Sigma(k); 
                       end
                   end
               end
           end
       end
       Sigma(j) = -ajnorm; 
    end 
end