function output=Export_Data(mySystem,exportName,varargin)
% this function exports and saves system data. the data is exported to the
% output variables in matlab form, and also saved to files in the current
% directory inside the new directory "exportName"
%Export_Data(mySystem,exportName,'ExportMat') saves mat files as well as
%excell
if isempty(mySystem.Pressure)
    error('system must be run before data can be exported')
end
mkdir(exportName) %make directory for output
%% calculate additional derived properties
sp=0*mySystem.Pressure;
rho=sp;
for i=1:length(sp)
    [~, ~, ~, rho(i), ~, ~, ~, ~, ~,~,~,sp(i)] = Mixture_Properties(mySystem.P_m,mySystem.Temperature(i),mySystem.Dry_Switch,mySystem.Mixture_Array);
end
%% make plots
plots=mySystem.PlotSystem('Derived','forGUI');
output.plots=plots;
plotnames={'Pressure','Velocity','Temperature','Acoustic Power','Total Power','Mass flux'};
for i=1:6
    figure(plots{i})
    exportgraphics(plots{i},[exportName,'\',plotnames{i},'.png'])
end
%% make component table
Component_Table={};
for i=1:length(mySystem.Components)
    C=mySystem.Components_H{i}; %the component
    name_plus_type={upper(C.Name),upper(class(C))};
    Component_Table=[Component_Table;name_plus_type;print_component(mySystem.Components_H{i})];
end
Component_Table=cell2table(Component_Table);
Component_Table.Properties.VariableNames{1} = 'Property/COMPONENT NAME';
Component_Table.Properties.VariableNames{2} = 'Value/COMPONENT Type';
output.Component_Table=Component_Table;
try
writetable(Component_Table,[exportName,'\Component Data.xlsx'],'Sheet',1)
catch
    error('make sure output files are closed')
end
%% make properties table
Property_Table=cell(length(mySystem.Pressure),8);
counter=0;
for i=1:length(mySystem.Components)
    C=mySystem.Components_H{i}; %the component
    for j=counter+1:counter+length(C.Pressure)
        Property_Table{j,1}=C.Name;
    end
    counter=counter+length(C.Pressure);
end
Property_Table(:,2:10)=num2cell([mySystem.X,mySystem.Pressure,mySystem...
    .Velocity,mySystem.Temperature,mySystem.Acoustic_Power,mySystem.Total_Power,mySystem.Mass_Flux,rho,sp]);
Property_Table(1:10,11)={'Mean Pressure',mySystem.P_m,'Freqeuncy',mySystem.Frequency,...
    'Dry Switch',mySystem.Dry_Switch,'Inert Gas',mySystem.Inert,'Reactive Gas',mySystem.Reactive};
Property_Table=cell2table(Property_Table);
Property_Table.Properties.VariableNames={'Component','X','Pressure','Velocity','Temperature'...
    'Acoustic Power', 'Total Power','Mass flux','Density','Sound Speed','System Properties'};
writetable(Property_Table,[exportName,'\Property Data.xlsx'],'Sheet',1)

output.Property_Table=Property_Table;
if any(strcmp(varargin,'ExportMat'))
    save([exportName,'\Property_Data.mat'],'Property_Table')
    save([exportName,'\Component_Data.mat'],'Component_Table')
end
%% asisting function
    function tableout=print_component(Component)
        %this function exports all data about a component to a cell array
        classname=class(Component);
        Props=properties(classname);
        %properties not to be printed
        noprintprops={'Name','Pressure','Velocity','Temperature'...
            ,'Acoustic_Power','Total_Power','Mass_Flux','System'};
        tableout={};
        for ii=1:length(Props)-length(noprintprops)
            switch Props{ii}
                case noprintprops
                otherwise
                    try
                    tableout=[tableout;{Props{ii},num2str(Component.(Props{ii}))}];
                    catch
                        switch class(Component.(Props{ii}))
                            case 'function handle'
                                tableout=[tableout;{Props{ii},'function handle'}];
                            otherwise
                                tableout=[tableout;{Props{ii},'unkown property type'}];
                        end
                    end
            end        
        end
        tableout=[tableout;cell(1,2)];
    end
end