function [clipboard,varargout]= CutGroup(sys,varargin)
%This function cuts a group of components from within a system
% CutGroup(System,[locstart,locend]) cuts all the components in the system
%                                   between locs 
%the clipboard can also allow us to name the components in the workspace
%e.g: [clipboard,A,B]=CutGroup(System,locstart,locend) will give us
% assign handles to the first two components to the handles of A,B
%adding the instruction "'Smooth'" at the end of the inpur parameters
% will make the removal the components, smooth- maintaining guesses and
% targets convergance.
if any(strcmp(varargin,'Smooth'))
    Smooth=true;
else
    Smooth=false; 
end
locs=varargin{1};
if locs(2)>length(sys.Components)||locs(1)<1
    error('out of range')
end

clipboard={};
for i=locs(1):locs(2)
    CCC= sys.Components_H{locs(1)};
    if Smooth
        success=RemoveSmooth(sys,CCC,100);
        if ~success
            return
        end
    else
    sys.Remove(CCC)
    end
    clipboard=[clipboard,{CCC}];
    varargout=clipboard;
end
end

