function [clipboard,varargout] = CopyGroup(sys,class,locs,varargin)
%This function copies a group of components or links from within a system
% for components it will copy the components as they are (the varargin
% contains the old names to bypass Copy_component)
% for links:
% CopyGroup(System,class,[locstart,locend]) copies all the links in the system
%                                   between locs with the names "copy of . . ."
%
% CopyGroup(System,class,locstart,locend,names) copies all the links in the system
%                                   between locs with the names specified
%                                   by the cell array "names"

%the clipboard can also allow us to name the components in the workspace
%e.g: [clipboard,A,B]=CopyGroup(System,class,locstart,locend) will give us
% assign handles to the first two components to the handles of A,B

clipboard={};
if strcmp('Component',class)
    for i=locs(1):locs(2)
        if isempty(varargin)
            CCC= sys.Components_H{i}.Copy_Component;
        else
            CCC= sys.Components_H{i}.Copy_Component(varargin{1}{i-locs(1)+1});
        end
        clipboard=[clipboard,{CCC}];
    end
elseif strcmp('Link',class)
    for i=locs(1):locs(2)
        if isempty(varargin)
            CCC= sys.Links_H{i}.Copy_Link;
        else
            CCC= sys.Links_H{i}.Copy_Link(varargin{1}{i-locs(1)+1});
        end
        clipboard=[clipboard,{CCC}];
    end
else
    error('Enter a valid class type for copying')
end
varargout=clipboard;
end


