function  success=ChangeGas(MySystem,newGas,IOR,n)
%this function changes one working gas in the system, while maintaining
%guesses and targets
%changeGas(mySystem,newInert,'inert',n) changes the inert working gas
%ChangeGas(mySystem,newreactive,'reactive',n) changes the reactive workinng
%gas. the new gas is specified using a string, one of the gases in
%"property_tables". n is the number of steps in change

Guess0=MySystem.CollectGuessValues;           %initial guess values
Target_Value=MySystem.CollectTargetValues;         %target_value
%ensure small targets are targeted at 0
Target_Value(abs(Target_Value)<1e-3)=0;
switch IOR
    case 'Inert'
        oldGas=MySystem.Inert;
        Guess_Value=Guess0;
        for i=linspace(0,1,n)
            MySystem.Inert={newGas,i,oldGas,1-i};
            try
            [X,~, ~,Info]=MySystem.Run_System_GT...
                (Guess_Value,Target_Value,'Smart');
            catch
                Info=2;
            end
            if Info==1 %if converged
                Guess_Value=X;
                success=1;
            else
                sprintf('mixture change unsuccesfull, try changing number of steps')
                success=0;
                MySystem.Inert=oldGas;
                MySystem.Run_System_GT(Guess0,Target_Value,'Smart');
                return
            end
        end
        MySystem.Inert=newGas;
    case 'Reactive'
        oldGas=MySystem.Reactive;
        Guess_Value=Guess0;
        for i=linspace(0,1,n)
            MySystem.Reactive={newGas,i,oldGas,1-i};
            try
            [X,~, ~,Info]=MySystem.Run_System_GT...
                (Guess_Value,Target_Value,'Smart');
            catch
                Info=2;
            end
            if Info==1 %if converged
                Guess_Value=X;
                success=1;
            else
                 MySystem.Run_System_GT...
                    (Guess0,Target_Value,'Not_Smart');
                sprintf('mixture change unsuccesfull, try changing number of steps')
                MySystem.Reactive=oldGas;
                MySystem.Run_System_GT(Guess0,Target_Value,'Smart');
                success=0;
                return
            end
        end
        MySystem.Reactive=newGas;
    otherwise
        error(['third argument must be a string with the word "Inert" or', ...
            ' "Reactive"'])
end
end

