clear
close all
clc
%%%%%%%%%%
%% build system

D=5/1000*25.4; %5 inch to m
Fiveinch=TA_System('Fiveinch',1.38e6,121.155,'Helium','Water',1,[73549.3,0,557.922]);
%Fiveinch=TA_System('Fiveinch',1.38e6,121.55,'Helium','Water',0,[8.2526e4,5.875e-5,3000]);
Hot_Duct=TA_Round_Duct('Hot_Duct',Fiveinch,0.279,D);
Hot_Duct.Area=1.292e-2;
HHX=TA_Plate_HX('HHX',Fiveinch,6e-2,D,4.83e-4,0.393,'Ideal',2210);
HHX.Area=1.292e-2;
HHX.Lp=1e-5;

AHX=TA_Plate_HX('AHX',Fiveinch,5.08e-2,D,4.06e-4,203/228,'Ideal',-2096.2);
AHX.Area=0.01267;
AHX.Lp=1e-5;
Anchor=TA_Jacket_Target('Anchor',Fiveinch);
Ambient_Duct=TA_Round_Duct('Ambient_Duct',Fiveinch,3.65,D);
Ambient_Duct.Jacket=1;

%insert harend at the end of the system
END=TA_Hard_End('END','null');
Fiveinch.Insert(END)
% 
% %insert Honey stack in the middle of the system
%Honey_Stack=TA_Plate_Stack('Honey_Stack','null',0.279,D,1e-3,0.81,'Stainless');
%Honey_Stack.Lp=5e-5;
Honey_Stack=TA_Circular_Stack('Honey_Stack','null',0.279,0.01292,1e-3,0.81,5e-5,'Stainless');
Fiveinch.Insert(Honey_Stack,3)
% runsystem button
%collect data?
%no
Fiveinch.runSystem(0);
%yes
Fiveinch.runSystem(1);
%%
% Lutube=0.6;
% hutube=4;
% Matrix=(h/l*rho,0;0)
% m=Ta_Transfer_Matrix('m',Fiveinch,Matrix)
%% add guesses and targets
Fiveinch.addGuess('Real','Frequency')                            %working frequency
Fiveinch.addGuess('Real','Begin',1)                       %real part of begining pressure
Fiveinch.addGuess('Real','Begin',3)                              %begining temperature
Fiveinch.addGuess('Real','AHX','Heat_Input')                     %heat at AHX 

Fiveinch.addTarget('Real','END','Target_Value')           %real part of 1/impedance at hardend
Fiveinch.addTarget('Imag','END','Target_Value')           %imaginary part of 1/impedance at hardend
Fiveinch.addTarget('Real','Anchor','Target_Value')               %jacket anchor, ensures H=E after HX
Fiveinch.addTarget('Real','AHX','SolidT')                        % solid temperature

%%  converge using guesses and targets
%converge to correct value, similar results to deltaEC
%in my computer took about 0.6 seconds, and deltaEC took about 0.06 seconds
targetvalues=[0,0,0, 303];
guessvalues=[100,7.5e4,900,-1500];

tic
[X,Fvec]=Fiveinch.Run_System_GT(guessvalues,targetvalues,'Smart');
toc
Fiveinch.PlotSystem('Derived')
%% additional convergence attempts
% 
%delta EC converges. this diverges but converges on smart attempt
guessvalues=[90,7.7e4,800,-1500];

X=Fiveinch.Run_System_GT(guessvalues,targetvalues,'Smart');

% 
% %converges on smart attempt, deltaEC diverges
% guessvalues=[90,7.5e4,800,-1500];
% tic
% X=Fiveinch.Run_System_GT(guessvalues,targetvalues);
% toc
 %% plot system
 Fiveinch.PlotSystem('Derived')
  %% change system gradualy, collect info about transition
 param1={'Frequency'};
 param2={'AHX','Heat_Input'};
 param3={'END','Pressure'};
 result=ChangeSmooth(Fiveinch,{'Ambient_Duct','Length'},2,10,'CollectData'...
 ,'CollectParams','PlotParams',param1,param2,param3,'CollectSystems');

% %% insert components gradually
% % create a new duct and insert it into the system
DUCT3=TA_Round_Duct('Duct3','null',0.2,D);
InsertSmooth(Fiveinch,DUCT3,7,100);
% 
% % create a new compliance and insert it into the system
% Compliance=TA_Compliance('Compliance','null',0.3,0.1);
% InsertSmooth(Fiveinch,Compliance,8,100);
% 
% %remove compliance
% RemoveSmooth(Fiveinch,Compliance,100);  
% 
%copy triplet- hx-stack- hx
names={'AHX2','HoneyStack2','HHX2'};
[clipboard,AHX2,HoneyStack2,HHX2] = CopyGroup(Fiveinch,'Component',[2,4],names);
HHX2.Heat_Input=0;
AHX2.Heat_Input=0;
PasteGroup(Fiveinch,7,clipboard,'Smooth');
% %% change lot's of stuff to reduce the temperature below boiling
% ChangeSmooth(Fiveinch,{'Honey_Stack','Y0'},4e-4,10);
% ChangeSmooth(Fiveinch,{'Honey_Stack','Length'},0.1,15);
% ChangeSmooth(Fiveinch,{'HoneyStack2','Length'},0.05,15);
% ChangeSmooth(Fiveinch,{'AHX','Y0'},2e-3,10);
% ChangeSmooth(Fiveinch,{'AHX2','Y0'},2e-3,10);
% ChangeSmooth(Fiveinch,{'HHX','Y0'},2e-3,10);
% ChangeSmooth(Fiveinch,{'HHX2','Y0'},2e-3,10);
% %% change mean  pressure
% % attempt using regular method-unsuccesfull
% %ChangeSmooth(Fiveinch,{'P_m'},1e-6,10);
% %change using a loop, along with heat
%     guessvalues=Fiveinch.CollectGuessValues;           %initial guess values
%     pressures=linspace(1.38e6,1e6,20);
%     Heats=linspace(2000,300,20);
% for i=1:20
%     Fiveinch.P_m=pressures(i);
%     HHX.Heat_Input=Heats(i);
%     [guessvalues,Fvec]=Fiveinch.Run_System_GT(guessvalues,targetvalues);
% end
% Fiveinch.PlotSystem('Derived')
% %% save point- workspace_Fiveinch
% %load workspace_Fiveinch
% 
% % %% wet system 
% % %SwitchDry(Fiveinch,4); % attempt using regular method-unsuccesfull
% % 
% % ChangeSmooth(Fiveinch,{'Dry_Switch'},0,4);
% % Fiveinch.Run_System_GT(G,targetvalues);
% % Fiveinch.PlotSystem('Derived')
% % %% save point- workspace_Fiveinch_2
% % %load workspace_Fiveinch_2
% % %% change working mixture from helium-water to air-methanol
% % % run this line by line. if a line doesn't work the first time, try again
% % ChangeGas(Fiveinch,'Hydrogen','inert',5)
% % ChangeGas(Fiveinch,'Air','inert',5)
% % ChangeSmooth(Fiveinch,{'AHX','SolidT'},200,10);
% % ChangeGas(Fiveinch,'Methanol','reactive',5)
% % ChangeSmooth(Fiveinch,{'AHX','SolidT'},290,10);
