clear
close all
clc
%%
A1=0.012;
D1=sqrt(A1/pi)*2;
D2=0.008;

%%
M1=TA_System('M1',1e5,126.06,'Air','Water',1,[4769.6,0,537.27]);
Hot_Duct=TA_Round_Duct('Hot_Duct',M1,0.13,D1);
HHX=TA_Plate_HX('HHX',M1,1.6e-2,D1,7e-4,0.393,'Copper',350);
HHX.Lp=5e-5;
Stack=TA_Rectangular_Stack('Stack',M1,5e-2,D1,6.3e-4,6.3e-4,0.6,'Celcor');
Stack.Lp=1e-4;
AHX=TA_Plate_HX('AHX',M1,2.2e-2,D1,7e-4,0.65,'Copper',-341.66);
AHX.Lp=5e-5;
Anchor=TA_Jacket_Target('Anchor',M1);
Duct1=TA_Round_Duct('Duct1',M1,0.4,D1);
Duct1.Jacket=1;
CONE=TA_Linear_Cone('CONE',M1,1.5,D1,D2);
CONE.Jacket=1;
END=TA_Hard_End('END',M1);
 %% add check valve
% Mat=[0,0;0,0]; %no changes
% Mat=[1,1;1,1]/-200; %small changes in all parameters
% [ ~, ~, ~, rho, ~, ~, ~, ~, ~,~,~,sp] = Mixture_Properties(M1.P_m,500,M1.Dry_Switch,M1.Mixture_Array);
% Scaling= rho*sp/CONE.Area_2;
% Mat=Mat./[1,1/Scaling;Scaling,1];
% CheckValve=TA_Transfer_Matrix('CheckValve','null',Mat);
% M1.Insert(CheckValve,7)


%% run system
M1.runSystem(1);
%% add guesses and targets
M1.addGuess('Frequency')                            %working frequency
M1.addGuess('Real','Begin',1)                       %real part of begining pressure
M1.addGuess('Begin',3)                              %begining temperature
M1.addGuess('AHX','Heat_Input')                     %heat at AHX 


M1.addTarget('Real','END','Target_Value')           %real part of 1/impedance at hardend
M1.addTarget('Imag','END','Target_Value')           %imaginary part of 1/impedance at hardend
M1.addTarget('Anchor','Target_Value')               %jacket anchor, ensures H=E after HX
M1.addTarget('AHX','SolidT')                        %solid temperatures

%%  converge using guesses and targets
%converge to correct value, similar results to deltaEC
%in my computer took about 0.6 seconds, and deltaEC took about 0.06 seconds
targetvalues=[0,0,0, 323];
guessvalues=[126,4769,537,-341.66];
tic
[X,Fvec]=M1.Run_System_GT(guessvalues,targetvalues);
toc
 M1.PlotSystem('Derived')
