classdef TA_Round_Duct <TA_Duct
    %describes a duct in a thermoacoustic system
    properties (SetObservable=true,Dependent)
        % dependent geometrical properties
        Diameter...                                % duct diameter    [m]
            (1,1) double{mustBeNonnegative}
        Area                              % duct area        [m^2]
        Rh                                % hydraulic radius [m]
    end   
  %  properties (Hidden,AbortSet=true)
    properties (Hidden)
     % a parameter which keeps diameter's value and connects to the other parameters:
        Diameter_val...           % duct diameter    [m]
            (1,1) double{mustBeNonnegative} =0.10032
    end
    methods
        %% constructor
        function obj = TA_Round_Duct(name,system,length,diameter,varargin)
            obj@TA_Duct(name,system,length,varargin{:})
            obj.Diameter_val=diameter;
        end

        %% set method for diameter
        function set.Diameter(obj,value)
            obj.Diameter_val=value;
        end
        %% get method for diameter
        function value=get.Diameter(obj)
            value=obj.Diameter_val;
        end
        
        %% set method for area
        function set.Area(obj,value)
            obj.Diameter_val=(value/pi*4)^0.5;
        end
        %% get method for area
        function value=get.Area(obj)
           value=pi*obj.Diameter_val^2/4;
        end

        %% set method for rh
        function  set.Rh(obj,value)
            obj.Diameter_val=value*4;      
        end
        %% get method for Rh
        function value=get.Rh(obj)
            value=obj.Diameter_val/4;
        end
    end
end

