classdef TA_Link_Relation<TA_Link
    %this class makes a link of a chosen relation between two or more properties in a TA_System
    % NOT YET MORE THAN 2 PROPERTIES!

properties
    Multiplier (1,1) double % the multiplier for Relation Link.
    Exponent (1,1) double % the exponent for Relation Link.
    Link_Type = 'Relation'  % Type of the link
end

methods
    %% constructor
    function obj = TA_Link_Relation(Name,system,Linked_Properties,forGUI,multiplier,exponent)
        obj@TA_Link(Name,system,Linked_Properties,forGUI)
            obj.Multiplier = multiplier;
            obj.Exponent = exponent;

        if obj.Link_Fail_Flag ~= 1 % if the link passed the first validation
            Specific_Link_Validation(obj)
        end
        if obj.Link_Fail_Flag ~= 1 % if the link passed the specific validation
            Add_Link(obj)
        end
    end

    %% main link function
    function Link_Function(obj,Source,Data,index)
        % format: num1 = multiplier*(num2^exponent)
        
        obj.System_H.Chain_Link_Error_Flag = 0;
        possible_parameter_index = obj.Linked_Properties{index}{end}; % in case the changed parameter has a specfic index like Begin(3)
        if isnumeric(possible_parameter_index)
            changed_val = Data.AffectedObject.(Source.Name)(possible_parameter_index);
            if index == 2
                correlated_val = obj.Multiplier*(changed_val^obj.Exponent); % num1 will change
            else
                correlated_val = ((1/obj.Multiplier)*changed_val)^(1/obj.Exponent); % num2 will change
            end
        else
            changed_val = Data.AffectedObject.(Source.Name);
            if index == 2
                correlated_val = obj.Multiplier*(changed_val^obj.Exponent); % num1 will change
            else
                correlated_val = ((1/obj.Multiplier)*changed_val)^(1/obj.Exponent); % num2 will change
            end
        end

        for i = 1:size(obj.Linked_Properties,2)
            if index ~= i
                obj.Listeners{i}.Enabled = false;
                obj.System_H.Change_Property(obj.Linked_Properties{i},correlated_val)
                obj.Listeners{i}.Enabled = true;
                obj.Linked_Properties_Values(i) = correlated_val;
            else
                obj.Linked_Properties_Values(i) = changed_val;
            end
            % checking for chain link error
            if obj.System_H.Chain_Link_Error_Flag 
                error("Chain Link Error")
            end
        end
    end

    %% specific link validation function
    % this function is specific to a link type, and it checks whether the
    % link can be created with the listed parameters, depending on if the
    % parameters are guesses/targets or can be guesses/targets.
    % TA_Link_Relation parameter validation protocol:
    % if one of the following conditions are met for the parameter, the link is forbidden:
    %   is a guess
    %   can be target

    function Specific_Link_Validation(obj)
    
        try
            if length(obj.Linked_Properties) > 2
                error('Only two parameters can be linked in this link type')
            end
            for i = 1:length(obj.Linked_Properties)  
            
                % getting the component meta data, and the property's location in it
                [metadata,metaloc] = get_property_meta(obj,i);

                % as the parameter's location is found, the specific validation will follow.
                % if one of the following conditions are met, the link is forbidden
                % (for -> TA_Link_Equal_Relation):
                
                % is a guess
                isGuess = obj.System_H.Comparearray(obj.Linked_Properties{i},obj.System_H.Guesses); % scan the guesses list
                if isGuess
                    error('Parameter can not be a guess in normal relation link')
                end

                % can be target
                if (isa(metadata.PropertyList(metaloc).SetAccess, 'char') && strcmp(metadata.PropertyList(metaloc).SetAccess,'protected')) ||...
                        isa(metadata.PropertyList(metaloc).SetAccess, 'cell')
                    error('A parameter that can be target, can not be linked in this link type')
                end
            end

        catch me
            for i = 1:length(obj.Listeners)
                delete(Equal_Link.Listeners{i})
            end
            obj.Listeners = [];
            obj.System_H.Remove_Link(obj.Name)
            error(['The link cannot be created, because of a parameter with the following issue:',newline,me.message])
        end
    
    end
end
end