classdef TA_Link_Fixed_Sum<TA_Link
    %this class makes a link of a certain sum between two or more properties in a TA_System
    %the first component assigned is defined as "main"
    %if the main property is changed, the total sum will recieve the delta
    %if another any other property is changed, the total sum will remain constant, and the main will recieve the delta

properties 
    Sum (1,1) double % Fixed total sum of the linked properties
    Link_Type = 'Fixed_Sum'  % Type of the link
end

methods
    %% constructor
    function obj = TA_Link_Fixed_Sum(Name,system,Linked_Properties,forGUI)
        obj@TA_Link(Name,system,Linked_Properties,forGUI)
            obj.Sum = sum(obj.Linked_Properties_Values);

        if obj.Link_Fail_Flag ~= 1 % if the link passed the first validation
            Specific_Link_Validation(obj)
        end
        if obj.Link_Fail_Flag ~= 1 % if the link passed the specific validation
            Add_Link(obj)
        end
    end
    
    %% main link function
    function Link_Function(obj,Source,Data,index,~,~)    
        obj.System_H.Chain_Link_Error_Flag = 0;
        possible_parameter_index = obj.Linked_Properties{index}{end}; % in case the changed parameter has a specific index like Begin(3)
        if isnumeric(possible_parameter_index)
            changed_val = Data.AffectedObject.(Source.Name)(possible_parameter_index);
        else
            changed_val = Data.AffectedObject.(Source.Name);
        end
        
        if index == 1 % change in the main component
            obj.Sum = obj.Sum + (changed_val-obj.Linked_Properties_Values(1));
            obj.Linked_Properties_Values(1) = changed_val;
        else
            delta = changed_val - obj.Linked_Properties_Values(index);
            if obj.Linked_Properties_Values(1) - delta <= 0
                error("Cannot maintain Fixed Sum link with this value")
            else
                obj.Linked_Properties_Values(1) = obj.Linked_Properties_Values(1) - delta;
                obj.Linked_Properties_Values(index) = obj.Linked_Properties_Values(index) + delta;
                obj.Listeners{1}.Enabled = false;
                obj.System_H.Change_Property(obj.Linked_Properties{1},obj.Linked_Properties_Values(1))
                obj.Listeners{1}.Enabled = true;
            end
        end
        % checking for chain link error
        if obj.System_H.Chain_Link_Error_Flag 
            error("Chain Link Error")
        end

    end
    %% specific link validation function
    % this function is specific to a link type, and it checks whether the
    % link can be created with the listed parameters, depending on if the
    % parameters are guesses/targets or can be guesses/targets.
    % TA_Link_Fixed_Sum parameter validation protocol:
    % if one of the following conditions are met for the parameter, the link is forbidden:
    %   main can be target

    function Specific_Link_Validation(obj)
    
        try     
                % getting the main component meta data, and the property's location in it
                [metadata,metaloc] = get_property_meta(obj,1);

                % as the parameter's location is found, the specific validation will follow.
                % if one of the following conditions are met, the link is forbidden
                % (for -> TA_Link_Fixed_Sum): 

                % main can be target
                if (isa(metadata.PropertyList(metaloc).SetAccess, 'char') && strcmp(metadata.PropertyList(metaloc).SetAccess,'protected')) ||...
                        isa(metadata.PropertyList(metaloc).SetAccess, 'cell')
                    error('A parameter that can be target, can not be linked as main parameter in this link type')
                end

        catch me
            for i = 1:length(obj.Listeners)
                delete(Equal_Link.Listeners{i})
            end
            obj.Listeners = [];
            obj.System_H.Remove_Link(obj.Name)
            error(['The link cannot be created, because of a parameter with the following issue:',newline,me.message])
        end
    
    end
end


end