classdef TA_Link_Equal_Hierarchy<TA_Link
    %this class makes a link of equality between two or more properties in a TA_System

properties
    Link_Type = 'Equal_Hierarchy'  % Type of the link
end

methods
    %% constructor
    function obj = TA_Link_Equal_Hierarchy(Name,system,Linked_Properties,forGUI)
        obj@TA_Link(Name,system,Linked_Properties,forGUI)

        if obj.Link_Fail_Flag ~= 1 % if the link passed the first validation
            Specific_Link_Validation(obj)
        end
        if obj.Link_Fail_Flag ~= 1 % if the link passed the specific validation
            Add_Link(obj)
        end

    end

    
    %% main link function
    function Link_Function(obj,Source,Data,index,~,~)
        obj.System_H.Chain_Link_Error_Flag = 0;
        if index == 1 % making sure only the primary can be changed
            possible_parameter_index = obj.Linked_Properties{index}{end}; % in case the changed parameter has a specfic index like Begin(3)
            if isnumeric(possible_parameter_index)
                changed_val = Data.AffectedObject.(Source.Name)(possible_parameter_index);
            else
                changed_val = Data.AffectedObject.(Source.Name);
            end
            for i = 1:size(obj.Linked_Properties,2)
                if index ~= i
                    obj.Listeners{i}.Enabled = false;
                    obj.System_H.Change_Property(obj.Linked_Properties{i},changed_val)
                    obj.Listeners{i}.Enabled = true;
                    obj.Linked_Properties_Values(i) = changed_val;
                else
                    obj.Linked_Properties_Values(i) = changed_val;
                end
                % checking for chain link error
                if obj.System_H.Chain_Link_Error_Flag 
                    error("Chain Link Error")
                end
            end
        else % if it is secondary, then doesnt let the parameter to change
            error("The changed parameter is secondary in a Hierarchy link, and therefore can not be changed")
        end
    end

    %% specific link validation function
    % this function is specific to a link type, and it checks whether the
    % link can be created with the listed parameters, depending on if the
    % parameters are guesses/targets or can be guesses/targets.
    % TA_Link_Equal_Hierarchy parameter validation protocol:
    % if one of the following conditions are met for the parameter, the link is forbidden:
    %   secondary is an actual guess
    %   secondary can be target

    function Specific_Link_Validation(obj)
    
        try
            
            for i = 2:length(obj.Linked_Properties)  % skips the primary parameter
            
                % getting the component meta data, and the property's location in it
                [metadata,metaloc] = get_property_meta(obj,i);

                % as the parameter's location is found, the specific validation will follow.
                % if one of the following conditions are met, the link is forbidden
                % (for -> TA_Link_Equal_Hierarchy): 
                
                % secondary is an actual guess
                isGuess = obj.System_H.Comparearray(obj.Linked_Properties{i},obj.System_H.Guesses); % scan the guesses list
                if isGuess
                    error('Secondary link parameter can not be a guess')
                end

                % secondary can be target
                if (isa(metadata.PropertyList(metaloc).SetAccess, 'char') && strcmp(metadata.PropertyList(metaloc).SetAccess,'protected')) ||...
                        isa(metadata.PropertyList(metaloc).SetAccess, 'cell')
                    error('A parameter that can be target, can not be linked as secondary parameter in this link type')
                end
            end


        catch me
            for i = 1:length(obj.Listeners)
                delete(Equal_Link.Listeners{i})
            end
            obj.Listeners = [];
            obj.System_H.Remove_Link(obj.Name)
            obj.Link_Fail_Flag = 1;
            error(['The link cannot be created, because of a parameter with the following issue:',newline,me.message])
        end
    
    end
end


end