classdef TA_Linear_Cone <TA_Cone
    %describes a duct in a thermoacoustic system
    properties (SetObservable=true,Dependent)
        %% dependent geometrical properties
        Diameter_1  (1,1) double{mustBeNonnegative} % first diameter  [m]  
        Diameter_2  (1,1) double{mustBeNonnegative} % second diameter [m]
        Area_1      (1,1) double{mustBeNonnegative} % first area     [m^2]
        Area_2      (1,1) double{mustBeNonnegative} % second area    [m^2]
        Rh_1        (1,1) double{mustBeNonnegative}  % hydraulic radiuses [m]
        Rh_2        (1,1) double{mustBeNonnegative}        
    end   
    properties (Hidden,AbortSet=true)
        Diameter_1_val % a parameter which keeps diameter's value and connects to the other parameters.
        Diameter_2_val
    end
    methods
        %% constructor
        function obj = TA_Linear_Cone(name,system,length,D1,D2,varargin)
            obj@TA_Cone(name,system,length,varargin{:})
            obj.Diameter_1_val=D1;
            obj.Diameter_2_val=D2;
        end

        %% set method for diameter 1
        function set.Diameter_1(obj,value)
            obj.Diameter_1_val=value;
        end
        %% get method for diameter 1
        function value=get.Diameter_1(obj)
                value=obj.Diameter_1_val;
        end
          %% set method for diameter 2
        function set.Diameter_2(obj,value)
            obj.Diameter_2_val=value;
        end
        %% get method for diameter 2
        function value=get.Diameter_2(obj)
                value=obj.Diameter_2_val;
        end

        %% set method for area 1
        function set.Area_1(obj,value)
            obj.Diameter_1_val=(value/pi*4)^0.5;
        end
        %% get method for area 1
        function value=get.Area_1(obj)
           value=pi*obj.Diameter_1_val^2/4;
        end
        %% set method for area 2
        function set.Area_2(obj,value)
            obj.Diameter_2_val=(value/pi*4)^0.5;
        end
        %% get method for area 2
        function value=get.Area_2(obj)
           value=pi*obj.Diameter_2_val^2/4;
        end

        %% set method for Rh 1
        function  set.Rh_1(obj,value)
            obj.Diameter_1_val=value*4;       
        end
        %% get method for Rh 1
        function value=get.Rh_1(obj)
            value=obj.Diameter_1_val/4;
        end
             %% set method for Rh 2
        function  set.Rh_2(obj,value)
            obj.Diameter_2_val=value*4;        
        end
        %% get method for Rh 2
        function value=get.Rh_2(obj)
            value=obj.Diameter_2_val/4;
        end
        %% calculation methods
        function A=Calc_A(obj,x_rel)
            r=obj.Rh_1+x_rel/obj.Length*(obj.Rh_2-obj.Rh_1);
            A=pi*r^2*4;
        end
        function rh=Calc_Rh(obj,x_rel)
            rh=obj.Rh_1+x_rel/obj.Length*(obj.Rh_2-obj.Rh_1);
            
        end
    end
end

