classdef  TA_Calculator<TA_rget
    % allows a user-defined function on components of a system to be a target.
    % This is not a physical system component.

    properties (SetAccess=?TA_Component,SetObservable=true)
        Target_Value
        Target_Definition=['Custom Target defined by a custom function']
    end
    properties (SetAccess = public)
        custom_function
        tokens
        relevant_components
    end
    properties (SetAccess = public, Transient)
        F
    end

    methods
        %% constructor
        % accepts either a function handler, or a string, that can be
        % parsed to a function with `custom_target()`. TODO - better docs
        %
        function obj = TA_Calculator(name,system,relevant_components)
            obj@TA_rget(name,system);
            obj.relevant_components = relevant_components;
            obj.tokens = {};
            obj.F = @(x,y,z) 0;
        end
        %% calculation method
        function Calculate_Target(obj, H)
            obj.Target_Value=obj.F(obj.System_H, obj, H);
        end
        function create_func(obj, tokens)
            obj.tokens = tokens;
            obj.F = custom_target(obj.tokens);
        end
        function set_relevant_components(obj, relevant_components)
            obj.relevant_components = relevant_components;
        end
        function append_relevant_component(obj, component)
            obj.relevant_components{end+1} = component;
        end
        function remove_relevant_component(obj, componentIndex)
            if componentIndex < 1 || ...
                    componentIndex > numel(obj.relevant_components)
                error('Cant remove component - Index' + ...
                    num2str(componentIndex) + 'is out of range');
            end
            obj.relevant_components(componentIndex) = [];

            % Update tokens' componentIndex
            for k = 1:numel(obj.tokens)
                if isprop(obj.tokens{k}, 'componentIndex')
                    if obj.tokens{k}.componentIndex == componentIndex
                        obj.tokens(k) = [];
                    elseif obj.tokens{k}.componentIndex > componentIndex
                        obj.tokens{k}.componentIndex = obj.tokens{k}.componentIndex - 1;
                    end
                end
            end
        end
        function clear_relevant_components(obj)
            obj.relevant_components = {};
        end
        function updateRelevantComponents(obj, old_system)
            %% update the relevant_component array after a system copy
            % TA_Calculator saves references to component objects in the
            % system. They must be updated after a system copy.
            % this method should be called IMMEDIATELY after copying
            % old_system, so that the locations of the components in
            % old_system and in the current system are still the same.
            % also, all tokens in the calculation should contain the new
            % TA_Calculator object.
            for i=1:length(obj.relevant_components)
                old_component = obj.relevant_components{i};
                loc = old_system.findLoc(old_component.Name);
                obj.relevant_components{i} = obj.System_H.Components_H{loc};
            end
            for i=1:length(obj.tokens)
                if strcmp(obj.tokens{i}.type, 'PROPERTY') && ...
                        ~strcmp(obj.tokens{i}.value, "H_Before")
                    obj.tokens{i}.componentManager = obj;
                end
            end
        end
    end
    methods (Static)
        function obj=loadobj(obj)
            obj.create_func(obj.tokens);
        end
    end
end
