classdef TA_Branch<TA_System
    properties (SetAccess=?TA_System)
        Location
        Mother_System
        Calc_Derived=0; % a boolean determining if to run the system with calc_derived
    end
    properties (Hidden,SetAccess=?TA_System)
        Mother_System_H
        H_end=nan;
    end
    methods
        function obj=TA_Branch(Name,Syst)
            obj@TA_System(Name,Syst.P_m,Syst.Frequency,Syst.Inert,...
                Syst.Reactive,Syst.Dry_Switch,[0,0,0])
            obj.Mother_System_H=Syst;
            obj.Mother_System=Syst.Name;
            obj.Location=size(Syst.Branches_H,2)+1;
            Syst.addBranch(Name);
            Syst.Branches_H=[Syst.Branches_H,{obj}];
        end
        function Refresh(obj)% update all properties based on Mother_System
            obj.P_m=obj.Mother_System_H.P_m;
            obj.Frequency=obj.Mother_System_H.Frequency;
            obj.Inert=obj.Mother_System_H.Inert;
            obj.Reactive=obj.Mother_System_H.Reactive;
            obj.Dry_Switch=obj.Mother_System_H.Dry_Switch;
        end
        function rename(obj,newName)
            obj.rename@TA_System(newName)
            obj.Mother_System_H.Branches{obj.Location}=newName;
        end
        function runSystem(obj,collectdata,varargin)
            if isempty(collectdata)
                obj.H_end=obj.runSystem@TA_System(obj.Calc_Derived,varargin{:});
            else
                obj.H_end=obj.runSystem@TA_System(collectdata,varargin{:});
            end
        end
        function cp=CopySystem(obj,newName,varargin)
            cp=obj.CopySystem@TA_System(newName,varargin{:});
            cp.Mother_System={};
            cp.Location=[];
            cp.Mother_System_H={};
        end
        function addGuess(~,~)
            error(['Do not add guesses to branches, all guesses'...
                ,'and targets should be managed through the mother system'])
        end
        function addTarget(~,~)
            error(['Do not add guesses to branches, all guesses'...
                ,'and targets should be managed through the mother system'])
        end
        function Run_System_GT(~,~,~,~)
            error('Do not try to run branches with guesses and targets')
        end
    end

end