    function [P,U,T,c,x_axis,t_step,success,vidFilePath,T1,C1]=MakeVideo(MySystem,n,t_res,export, vidFilePath)
% obj = name of the system
% n = number of cycles to preview
% t_res = total number of frames
% export = exports video file if==1
% vidFilePath = path to save the preview video when export == 0

t=linspace(0,n/MySystem.Frequency,t_res); %timeline

%Creating X axis
[T1,~,C1,~,Cm,x_axis]=MySystem.Calc_T1C1;
R=8.3144621; %Gas Constant

P=zeros(length(x_axis),length(t)); %Pressure
U=zeros(length(x_axis),length(t)); %Velocity
T=zeros(length(x_axis),length(t)); %Temperature
C=zeros(length(x_axis),length(t)); %Concentration


% Creating Tm
Tm=[];
for i=1:length(MySystem.Components)
    if MySystem.Components_H{i}.Length > 0
        Tm=[Tm;MySystem.Components_H{i}.Temperature];
    end
end

% Debugging output for T1, Tm, and x_axis lengths
%disp(['Length of Tm: ', num2str(length(Tm))]);
%disp(['Length of T1: ', num2str(length(T1))]);
%disp(['Length of x_axis: ', num2str(length(x_axis))]);

% Debugging output for Tm values
%disp('Tm values:');
%disp(Tm');

% Debugging output for T1 values
%disp('T1 values:');
%disp(T1');


%% Calculations
for t_step=1:length(t)
    for x_step=1:length(x_axis)
        P(x_step,t_step)=MySystem.P_m+real(MySystem.Pressure(x_step))...
            *cos(2*pi*MySystem.Frequency*t(t_step))+...
            imag(MySystem.Pressure(x_step))*sin(2*pi*MySystem.Frequency*t(t_step));
        U(x_step,t_step)=real(MySystem.Velocity(x_step))...
            *cos(2*pi*MySystem.Frequency*t(t_step))...
            +imag(MySystem.Velocity(x_step))*sin(2*pi*MySystem.Frequency*t(t_step)); 
        T(x_step,t_step)=Tm(x_step)+real(T1(x_step))*cos(2*pi*...
            MySystem.Frequency*t(t_step))+imag(T1(x_step))*sin(2*pi*MySystem.Frequency*...
            t(t_step));
        if ~MySystem.Dry_Switch
            C(x_step,t_step)=Cm(x_step)+real(C1(x_step))...
                    *cos(2*pi*MySystem.Frequency*t(t_step))+imag(C1(x_step))...
                    *sin(2*pi*MySystem.Frequency*t(t_step)); 
        end

    end
    if ~MySystem.Dry_Switch
        c(:,t_step)=C(:,t_step).*(P(:,t_step)./(R*T(:,t_step)));
    else
        c = C;
    end
end

% Helper function to ensure valid y-axis limits
function [minVal, maxVal] = ensureValidLimits(minVal, maxVal)
    % Reduce minVal and maxVal to scalar values
    minVal = min(minVal(:));
    maxVal = max(maxVal(:));

    if isnan(minVal)
        %error('Invalid limit: NaN detected in y-axis limits.');
        minVal=0;    
    end
     if isnan(maxVal)
        %error('Invalid limit: NaN detected in y-axis limits.');
        maxVal=0;    
    end
    if isinf(minVal) || isinf(maxVal)
        %error('Invalid limit: Inf detected in y-axis limits.');
    end
    if minVal == maxVal 
        % Add a small margin to ensure the limits are distinct
        margin = 0.01 * abs(maxVal);  % Use 1% of the value as margin
        minVal = minVal - margin;
        maxVal = maxVal + margin;
    end
     if minVal == 0 && maxVal==0 
        % Add a small margin to ensure the limits are distinct
        margin = 100;  % Use 1% of the value as margin
        maxVal = maxVal + margin;
    end
end

%% Preperations before plotting

% Calculate y-axis limits and ensure they are valid
[min_P, max_P] = ensureValidLimits(min(min(P)), max(max(P)));
[min_U, max_U] = ensureValidLimits(min(min(U)), max(max(U)));
[min_T, max_T] = ensureValidLimits(min(min(T)), max(max(T)));

if ~MySystem.Dry_Switch
    [min_C, max_C] = ensureValidLimits(min(min(c)), max(max(c)));
end

% Velocity plot
[min_y_V, max_y_V] = ensureValidLimits(min([min_P min_U]), max([max_P max_U]));
[min_y_T, max_y_T] = ensureValidLimits(min([min_P min_T]), max([max_P max_T]));

if ~MySystem.Dry_Switch
    [min_y_C, max_y_C] = ensureValidLimits(min([min_P min_C]), max([max_P max_C]));
end

%Optional Debugging Outputs
% fprintf('min_P: %f, max_P: %f\n', min_P, max_P);
% fprintf('min_U: %f, max_U: %f\n', min_U, max_U);
% fprintf('min_T: %f, max_T: %f\n', min_T, max_T);

% if ~MySystem.Dry_Switch
%    fprintf('min_C: %f, max_C: %f\n', min_C, max_C);
% end

% Velocity plot
max_y_V=max([max_P max_U]);
min_y_V=min([min_P min_U]);
% Temperature plot
max_y_T=max([max_P max_T]);
min_y_T=min([min_P min_T]);
if ~MySystem.Dry_Switch
    % Concentration plot
    max_y_C=max([max_P max_C]);
    min_y_C=min([min_P min_C]);
end

%color plate for background
clr={'r','c','m','g','b','y',[0.341,0.522,0.110],...
    [0.8,0.32,0],[0,0.89,0.59],[0,0.3255,0.5412]}; 

% Initialize video
if export==0
    if nargin < 5  % No custom path provided
            vidFilePath = fullfile(pwd, 'preview_video.mp4');
    end
        %Video = VideoWriter(vidFilePath, 'MPEG-4'); 
        %Video.FrameRate = 10;
        %open(Video)
        
else
    Video = VideoWriter(vidFilePath, 'MPEG-4');  % Initialize VideoWriter with the specified path
    Video.FrameRate = 10;  % Set frame rate
    open(Video);  % Open the video file for writing
    
end

%% plot
for t_step=1:length(t)
    clf
    %patching background
    x_patch=0;
    legnd=string.empty(0); %legend
    leg_indx=1;
    for i=1:length(MySystem.Components)
        j=i; %color index
        while j>10
            j=j-10;
        end
        x_p_add=MySystem.Components_H{i}.Length;
        % Maximizing figure window
        fig=gcf;
        fig.WindowStyle='normal';
        fig.WindowState='maximized';
        %
        switch MySystem.Dry_Switch
            case 0 % Dry switch OFF - three subplots
                subplot(3,1,1) % subplot 1
                patch([x_patch x_patch+x_p_add x_patch+x_p_add x_patch],...
                    [min_y_V,min_y_V,max_y_V,max_y_V], clr{j})
                alpha(0.3)
                subplot(3,1,2) % subplot 2
                patch([x_patch x_patch+x_p_add x_patch+x_p_add x_patch],...
                    [min_y_T,min_y_T,max_y_T,max_y_T], clr{j})
                alpha(0.3)
                subplot(3,1,3) % subplot 3
                patch([x_patch x_patch+x_p_add x_patch+x_p_add x_patch],...
                    [min_y_C,min_y_C,max_y_C,max_y_C], clr{j})
                alpha(0.3)
            case 1 % Dry switch ON - two subplots (no concentration)
                subplot(2,1,1) %subplot 1
                patch([x_patch x_patch+x_p_add x_patch+x_p_add x_patch],...
                    [min_y_V,min_y_V,max_y_V,max_y_V], clr{j})
                alpha(0.3)
                subplot(2,1,2) % subplot 2
                patch([x_patch x_patch+x_p_add x_patch+x_p_add x_patch],...
                    [min_y_T,min_y_T,max_y_T,max_y_T], clr{j})
                alpha(0.3)
        end
        x_patch=x_patch+x_p_add;
        if MySystem.Components_H{i}.Length>0    
            legnd{leg_indx}=MySystem.Components{i};
            leg_indx=leg_indx+1;
        end
        hold on
    end

    %plot Pressure
    switch MySystem.Dry_Switch
        case 0 % Dry switch OFF - three subplots
            % Subplot 1 - Velocity vs Pressure
            subplot(3,1,1) 
            % plot pressure
            yyaxis('left')
            hold on
            plot (x_axis,P(:,t_step),'LineWidth',2)
            ylim([min_P max_P])
            ylabel('Pressure (Pa)')
            % plot Velocity
            yyaxis('right')
            plot (x_axis,U(:,t_step),'LineWidth',2)
            ylim([min_U max_U])
            ylabel('Velocity (m^3/s)')
            %
            xlim([0 max(x_axis)])
            hold on
            sgtitle([MySystem.Name,', t = ',num2str(t(t_step)),' sec'], 'FontSize',12)  
            
            % Subplot 2 - Temperature vs Pressure
            subplot(3,1,2) 
            % plot Pressure
            yyaxis('left')
            hold on
            plot (x_axis,P(:,t_step),'LineWidth',2)
            ylim([min_P max_P])
            ylabel('Pressure (Pa)')
            % plot Temperature
            yyaxis('right')
            plot (x_axis,T(:,t_step),'LineWidth',2,'color','red')
            ylim([min_T max_T])
            set(gca,'YColor','red') % setting axis color
            ylabel('Temperature (K)')
            %
            xlim([0 max(x_axis)])
            hold on
            % Subplot 3 - Concentration vs Pressure
            subplot(3,1,3)
            %plot Pressure
            yyaxis('left')
            hold on
            plot (x_axis,P(:,t_step),'LineWidth',2)
            ylim([min_P max_P])
            ylabel('Pressure (Pa)')
            %plot Concentration
            yyaxis('right')
            plot (x_axis,c(:,t_step),'LineWidth',2,'color',[0.4275 0.8 0])
            ylim([min_C max_C])
            set(gca,'YColor',[0.4275 0.8 0]) % setting axis color
            ylabel('Concentration (mol/m^3)')
            %
            xlim([0 max(x_axis)])
            hold on
            lgd=legend(legnd,'Location','SouthOutside','Orientation',...
                'Horizontal','Box','off');
            lgd.Position(2)=0; %fixing legend position
            drawnow
        case 1
            % Subplot 1 - Velocity vs Pressure
            subplot(2,1,1) 
            % plot pressure
            yyaxis('left')
            hold on
            plot (x_axis,P(:,t_step),'LineWidth',2)
            ylim([min_P max_P])
            ylabel('Pressure (Pa)')
            % plot Velocity
            yyaxis('right')
            plot (x_axis,U(:,t_step),'LineWidth',2)
            ylim([min_U max_U])
            ylabel('Velocity (m^3/s)')
            %
            xlim([0 max(x_axis)])
            hold on
            sgtitle([MySystem.Name,', t = ',num2str(t(t_step)),' sec'], 'FontSize',12)  
            
            % Subplot 2 - Temperature vs Pressure
            subplot(2,1,2) 
            % plot Pressure
            yyaxis('left')
            hold on
            plot (x_axis,P(:,t_step),'LineWidth',2)
            ylim([min_P max_P])
            ylabel('Pressure (Pa)')
            % plot Temperature
            yyaxis('right')
            plot (x_axis,T(:,t_step),'LineWidth',2,'color','red')
            ylim([min_T max_T])
            set(gca,'YColor','red') % setting axis color
            ylabel('Temperature (K)')
            %
            xlim([0 max(x_axis)])
            lgd=legend(legnd,'Location','SouthOutside','Orientation',...
                'Horizontal','Box','off');
            lgd.Position(2)=0; %fixing legend position
            hold on
            drawnow
    end

    if export
        pause(0.01)
        frame = getframe(gcf); %get frame
        writeVideo(Video, frame);
    end
end


if export
    close(Video)
end
    

success = true;


end