function success=InsertSmooth(mySystem,myComponent,Location,n)
%this function inserts a component smoothly into a system while maintaining
%guesses and targets.
%input parameters- mySystem- the system,
%                  myComponent- a component.
%                  Location- wanted location of the component in system
%                  n- number of steps in change
%output parameters- success- a boolean indicating if the operation
%succeeded

%%
Guess_Value=mySystem.CollectGuessValues;
Target_Value=mySystem.CollectTargetValues;
%%
if isa(myComponent,'TA_Duct')||isa(myComponent,'TA_Stack')||isa(myComponent...
        ,'TA_Cone')||isa(myComponent,'TA_Regenerator')
    %% ducts, stacks, cones
    %add the component with 0 length and change it gradualy
    L=myComponent.Length;
    myComponent.Length=1e-13;
    mySystem.Insert(myComponent,Location)
    try
        results=ChangeSmooth(mySystem,{myComponent.Name,'Length'},L,n,'NoQuestions');
    catch
        results.Converged=0;
        myComponent.Length=1e-13;
        mySystem.Run_System_GT(Guess_Value,Target_Value)
    end
    if results.Converged
        sprintf(['component "',myComponent.Name,'" inserted successfully'])
        success=true;
    else
        sprintf(['failed to insert component "',myComponent.Name,'"'])
        success=false;
        mySystem.Remove(myComponent)
        mySystem.runSystem(1);
        myComponent.Length=L;
    end
elseif isa(myComponent,'TA_HX')
    %% heat exchanger
    %add the component with 0 length and 0 heat input and change it gradualy
    L=myComponent.Length;
    H=myComponent.Heat_Input;
    myComponent.Length=1e-13;
    myComponent.Heat_Input=1e-13;
    mySystem.Insert(myComponent,Location)
    try
        results1=ChangeSmooth(mySystem,{myComponent.Name,'Length'},L,n,'NoQuestions');
    catch
        results1.Converged=0;
        myComponent.Length=1e-13;
        mySystem.Run_System_GT(Guess_Value,Target_Value)
    end
    Converged=results1.Converged;
    if Converged &&abs(H)>1e-14
        try
            results2=ChangeSmooth(mySystem,{myComponent.Name,'Heat_Input'},H,n,'NoQuestions');
        catch
            results2.Converged=0;
            myComponent.Heat_Input=1e-13;
            mySystem.Run_System_GT(Guess_Value,Target_Value)
        end
        Converged=results2.Converged;
    end
    if Converged
        sprintf(['Component "',myComponent.Name,'" inserted successfully.'])
        success=true;
    else
        sprintf(['failed to insert component "',myComponent.Name,'" smoothly'])
        success=false;
        if results1.Converged
            myComponent.Length=1e-13;
            mySystem.Run_System_GT(Guess_Value,Target_Value);
        end
        mySystem.Remove(myComponent)
        myComponent.Length=L;
        myComponent.Heat_Input=H;
        mySystem.runSystem(1);
    end
elseif isa(myComponent,'TA_Compliance')
    %% compliance
    V=myComponent.Volume;
    myComponent.Volume=1e-13;
    mySystem.Insert(myComponent,Location)
    try
        results=ChangeSmooth(mySystem,{myComponent.Name,'Volume'},V,n,'NoQuestions');
    catch
        results.Converged=0;
        myComponent.Volume=1e-13;
        mySystem.Run_System_GT(Guess_Value,Target_Value)
    end
    if results.Converged
        sprintf(['component "',myComponent.Name,'" inserted successfully'])
        success=true;
    else
        sprintf(['failed to insert component "',myComponent.Name,'" smoothly'])
        success=false;
        mySystem.Remove(myComponent)
        mySystem.runSystem(1);
        myComponent.Volume=V;
    end
elseif isa(myComponent,'TA_VE_Speaker')||isa(myComponent,'TA_IE_Speaker')
    %% Loudspeaker
    myComponent.Silencer=1;
    mySystem.Insert(myComponent,Location)
    try
        results=ChangeSmooth(mySystem,{myComponent.Name,'Silencer'},0,n,'NoQuestions');
    catch
        results.Converged=0;
        myComponent.Silencer=1;
        mySystem.Run_System_GT(Guess_Value,Target_Value)
    end
    if results.Converged
        sprintf(['component "',myComponent.Name,'" inserted successfully'])
        success=true;
    else
        sprintf(['failed to insert component "',myComponent.Name,'" smoothly'])
        success=false;
        mySystem.Remove(myComponent)
        mySystem.runSystem(1);
        myComponent.Silencer=0;
    end

elseif isa(myComponent,'TA_Liquid_Piston')
    %% Liquid Piston
    %add the component with 0 rho and change it gradualy
    rho=myComponent.Rho;
    myComponent.Rho=1e-13;
    mySystem.Insert(myComponent,Location)
    try
        results=ChangeSmooth(mySystem,{myComponent.Name,'Rho'},rho,n,'NoQuestions');
    catch
        results.Converged=0;
        myComponent.Rho=1e-13;
        mySystem.Run_System_GT(Guess_Value,Target_Value)
    end
    if results.Converged
        sprintf(['component "',myComponent.Name,'" inserted successfully'])
        success=true;
    else
        sprintf(['failed to insert component "',myComponent.Name,'"'])
        success=false;
        mySystem.Remove(myComponent)
        mySystem.runSystem(1);
        myComponent.Rho=rho;
    end
    %% target
elseif isa(myComponent,'TA_rget')
    mySystem.Insert(myComponent,Location)
    success=1;
    sprintf(['Component "',myComponent.Name,'" inserted.',...
        'make sure you change the value gradually to avoid divergence'])
    %% other component
elseif isa(myComponent,'TA_Component')
    sprintf(['No method for inserting a component of class "',class(myComponent),...
        '" smoothly. inserting it regularly'])
    mySystem.Insert(myComponent,Location)
    
else
    error('not a component')
end
end

