clear
close all
clc
%% pre writing velocity at the begining
pahseubeg=15.113;  %deg
absubeg=1.5897e-2; %m^3/s
Ubeg=absubeg*exp(1i*pahseubeg*pi/180);
%% build system
RuiLoop=TA_System('RuiLoop',2e6,105.62,'Helium','Water',1,[97855.5,Ubeg,300.65]);

Duct1=TA_Round_Duct('Duct1',RuiLoop,2.6e-2,0.1);
Duct1.Area=5.3066e-4;

AHX=TA_Plate_HX('AHX',RuiLoop,3e-2,1,4e-4,0.26,'Ideal',-811);
AHX.Area=7.6940e-3;
AHX.Lp=1e-5;
 
 Regen=TA_Rectangular_Stack('Regen',RuiLoop,3e-2,AHX.Diameter,5e-5,5e-5,2e-5,'Stainless');
 Regen.Gas_Area_Ratio=0.74;


HHX=TA_Plate_HX('HHX',RuiLoop,3e-2,1,5e-4,0.26,'Ideal',905.76);
HHX.Area=7.6940e-3;
HHX.Lp=1e-5;

TBT=TA_Round_TBT('TBT',RuiLoop,5e-2,Duct1.Diameter,'Stainless',0.001);
TBT.A_Wall=1e-4;

AHX2=TA_Round_HX('AHX2',RuiLoop,0.42,Duct1.Diameter,'Copper',1e-8,-57);

Duct2=TA_Round_Duct('Duct2',RuiLoop,1.395+0.12,0.1);
Duct2.Area=5.3066e-4;


LOOPEND=TA_Loop_End_PHAB('LOOPEND',RuiLoop);
%% run system
  RuiLoop.runSystem(1);
  RuiLoop.PlotSystem('Derived')
%% add guesses and targets
RuiLoop.addGuess('Frequency')              %working frequency
RuiLoop.addGuess('Real','Begin',1)         %real part of begining pressure
RuiLoop.addGuess('Abs','Begin',2)          %magnitude of begining velocity
RuiLoop.addGuess('Phase','Begin',2)        %magnitude of begining velocity
RuiLoop.addGuess('Begin',3)                %begining temperature
RuiLoop.addGuess('AHX','Heat_Input')       %heat input to AHX
RuiLoop.addGuess('HHX','Heat_Input')       %heat input to HHX
RuiLoop.addGuess('AHX2','Heat_Input')      %heat input to AHX2


RuiLoop.addTarget('AHX','SolidT')                     %Solid T of AHX
RuiLoop.addTarget('HHX','SolidT')                     %Solid T of HHX
RuiLoop.addTarget('AHX2','SolidT')                    %Solid T of AHX2
RuiLoop.addTarget('Abs','LOOPEND','Target_Value',1)   % absolute pressure periodicity
RuiLoop.addTarget('Abs','LOOPEND','Target_Value',2)   % absolute Velocity periodicity
RuiLoop.addTarget('Phase','LOOPEND','Target_Value',2) %  pressure phase periodicity
RuiLoop.addTarget('Phase','LOOPEND','Target_Value',1) % Velocity phase periodicity
RuiLoop.addTarget('LOOPEND','Target_Value',3)         % Temperature  periodicity
%% converge using guesses and targets
% values for rectangular pores- very close and close enough
guessvalues=[105.62,129000,2.0585e-2,14.947/180*pi,302.86,-1335.1,1486.1,-94.356];
%guessvalues=[90,130000,2e-2,10/180*pi,300,-1000,1000,0];

%very close value for regenerator
guessvalues=[105.11,97855.5,0.0158971,15.1133/180*pi,300.65,-811,905,-56];

targetvalues=[293.15,356.5,293.15,1,1,-pi/2,-pi/2,1];

tic
[X,Fvec]=RuiLoop.Run_System_GT(guessvalues,targetvalues);
toc

RuiLoop.PlotSystem('Derived')
% %% remove guess and target from list
% RuiLoop.Remove_Guess(7)
% RuiLoop.Remove_Target(2)
% guessvalues=[105.62,129000,2.0585e-2,14.947/180*pi,302.86,-1335.1,-94.356];
% targetvalues=[293.15,293.15,1,1,-pi/2,-pi/2,1];
% tic
% [X,Fvec]=RuiLoop.Run_System_GT(guessvalues,targetvalues);
% toc
% %% change temperature to correspond with initial temperature
% ChangeSmooth(RuiLoop,{'AHX','SolidT'},303,2);
% %% change heat input and collect the data
% results=ChangeSmooth(RuiLoop,{'HHX','Heat_Input'},1000,10,'CollectData','CollectSystems');
% SYS_array=results.Systems;
% freqs=Retrieve(SYS_array,{'Frequency'});
% Pbegs=Retrieve(SYS_array,{'Pressure',1});
% Temps=Retrieve(SYS_array,{'AHX','Temperature',1})
% %% collect values for comparison
% heats=[1000 800 600 400 200 60];
% TCS=[28.5,24.8,20.9,17,14.4,11.8]+273.15;
% [THS,PAS,Freqs]=deal(TCS*0);
% 
% for i=1:length(heats)
%     results=ChangeSmooth(RuiLoop,{'HHX','Heat_Input'},heats(i),10);
%     ChangeSmooth(RuiLoop,{'AHX','SolidT'},TCS(i),10);
%     THS(i)=HHX.SolidT;
%     PAS(i)=abs(RuiLoop.Begin(1));
%     Freqs(i)=RuiLoop.Frequency;
% end
% %%
% load('C:\Users\nathan\Desktop\נתן\תואר שני\קוד רוי\article\code articles\figures\data_code_RUILOOP.mat')
% THS2=[117,106,94,80,66,49]+273;
% PAS2=[0.1,0.087,0.073,0.056,0.037,0.0118]*1e6;
% Freqs2=[99.7,99.3,98.8,98.3,98,97.88];
% figure(7)
% plot(heats,THS,heats,THS2)
% title('hot temperature comparison')
% xlabel('heat [W]')
% ylabel('TH [k]')
% legend('code','experiments')
% figure (8)
% plot(heats,PAS,heats,PAS2)
% title('pressure amplitude comparison')
% xlabel('heat [W]')
% ylabel('PA [kPa]')
% legend('code','experiments')
% figure(9)
% plot(heats,Freqs,heats,Freqs2)
% title('frequency comparison')
% xlabel('heat [W]')
% ylabel('frequency [1/s]')
% legend('code','experiments')