function  Add_Link_GUI(~,~,TheApp,TAG,Property,isComplex,n,label,Additionals)
%this function adds a link to the system following a context menu selection
%"add link"
%iscomplex indicates whether the selected value is complex or not. n is the
%index of property
%label is the label whos color will be changed
%labels as well as additionals will recieve a tooltip and context menu
    if isempty(TheApp)
        TheApp=TAG.App_handle;
    end
    fig=ancestor(label,'matlab.ui.Figure','toplevel'); %setting parent figure for alerts
    if ~isa(TAG,'char')&&isempty(TAG.TAC.System)
        uialert(fig,'Component is not in system','Message','Icon','info','Modal',false)
        return
    end
    
    if TheApp.Smooth_Mode
        uialert(fig,'Cannot change links and targets in smooth mode','Message','Icon','info','Modal',false)
        return
    end
    
 %   if ischar(isComplex)
 %       RIPA=isComplex;
 %   elseif isComplex
 %       %determine if real part, immaginary part etc should be added
 %       selection = uiconfirm(fig,'which part of the complex number would you like to make a guess?','complex number',...
 %           'Options',{'Real Part','Imaginary Part','Absolute value','Phase'});
 %       switch selection
 %           case 'Real Part'
 %               RIPA='Real';
 %           case 'Imaginary Part'
 %               RIPA='Imag';
 %           case 'Absolute value'
 %               RIPA='Abs';
 %           case 'Phase'
 %               RIPA='Phase';
 %       end
 %   else
 %       RIPA='Real';
 %   end
    
    if isa(TAG,'char')
        %% system link
        %add guess to tac
        try
            TheApp.System_H.addGuess(RIPA,Property,n)
        catch me
            uialert(fig,['Error occured during guess addition. Message was: "'...
                ,regexprep(me.message, '<.*?>', '' ),'".'],...
                'Message','Icon','info','Modal',false)
            return
        end
        T_Component=TAG; %for table
        %change label color and tooltip
        label.FontColor=TheApp.Colors.GuessColor;
        label.Tooltip=[label.Text,' Is a system guess'];
        
    else
        %% component guess
        %add guess to tac
        try
            TheApp.System_H.addGuess(RIPA,TAG.TAC.Name,Property,n)
        catch me
            uialert(fig,['Error occured during guess addition. Message was: "'...
                ,regexprep(me.message, '<.*?>', '' ),'".'],...
                'Message','Icon','info','Modal',false)
            return
        end
        T_Component=TAG.TAC.Name;
        %change label color and tooltip
        if min(label.FontColor==TheApp.Colors.TargetColor)||min(label.FontColor==TheApp.Colors.BothColor)
            %if object is already a target
            label.FontColor=TheApp.Colors.BothColor;
            label.Tooltip=[label.Text,' Is a system guess and a system target'];
        else
            label.FontColor=TheApp.Colors.GuessColor;
            label.Tooltip=[label.Text,' Is a system guess'];
        end
        if min(TAG.Button.FontColor==TheApp.Colors.TargetColor)||min(TAG.Button.FontColor==TheApp.Colors.BothColor)
            %if button  already contains a target
            TAG.Button.FontColor=TheApp.Colors.BothColor;
        else
            TAG.Button.FontColor=TheApp.Colors.GuessColor;
        end
        
    end
    %% context menus
    % label context menu
    if isempty(label.UserData.guessnum)
        uimenu(label.ContextMenu,'Text','Remove Guess',"MenuSelectedFcn" ...
            ,{@Remove_Guess_Context,TheApp,label});
        %button context menu
        if ~isa(TAG,'char') %if it is a button label
            if isempty(TAG.Remove_Guess_Menu)
                TAG.Remove_Guess_Menu=uimenu(TAG.Button.ContextMenu,'Text','Remove Guess');
                TAG.Remove_All_Guesses_Menu=uimenu(TAG.Button.ContextMenu,'Text','Remove All Guesses'...
                    ,"MenuSelectedFcn",@TAG.Remove_Guesses);
            end
            
            uimenu(TAG.Remove_Guess_Menu,'Text',label.Text,"MenuSelectedFcn" ...
                ,{@Remove_Guess_Context,TheApp,label});
        end
    end
    
    
    %% add additionals
    for i=1:length(Additionals)
        Additionals{i}.Tooltip=label.Tooltip;
        Additionals{i}.ContextMenu=label.ContextMenu;
    end
    %% add to guess table (including context menu)
    values=TheApp.System_H.CollectGuessValues;
    T_Value=values(end);
    if (isempty(TheApp.Guess_Table.Data))
        TheApp.Guess_Table.Data={'1',T_Component,label.Text,RIPA,T_Value,NaN}; %add to table
        TheApp.Guess_Table.UserData.GuessCM=uimenu(TheApp.GuessTableContextMenu,'Text','Remove Guess');
        TheApp.Guess_Table.UserData.ALLGuessCM=uimenu(TheApp.GuessTableContextMenu,'Text'...
            ,'Remove All Guesses',"MenuSelectedFcn",{@Remove_All_Guesses,TheApp});
        
    else
        row_num=height(TheApp.Guess_Table.Data);
        TheApp.Guess_Table.Data=[TheApp.Guess_Table.Data;{num2str(row_num+1),T_Component,label.Text,RIPA,T_Value,NaN}];
    end
    uimenu(TheApp.Guess_Table.UserData.GuessCM,'Text',...
        [num2str(length(values)),' - ',TheApp.Guess_Table.Data{length(values),2},' - ',TheApp.Guess_Table.Data{length(values),3}],...
        "MenuSelectedFcn",{@Remove_Guess_GUI,TheApp,length(values)});
    TheApp.Guess_Table_2.Data=TheApp.Guess_Table.Data;
    %% add userdata to label and everythin to apps guess data
    label.UserData.guessnum=[label.UserData.guessnum;length(values)];
    TheApp.Guess_Labels=[TheApp.Guess_Labels;{label}];
    TheApp.Guess_Additionals=[TheApp.Guess_Additionals;{Additionals}];
    TheApp.Guess_TAGs=[TheApp.Guess_TAGs;{TAG}];
end

